/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation.profiles;

import com.pdftools.internal.NativeObject;
import com.pdftools.signaturevalidation.DataSource;
import com.pdftools.signaturevalidation.profiles.RevocationCheckPolicy;
import java.util.EnumSet;

public class TrustConstraints
extends NativeObject {
    protected TrustConstraints(long handle) {
        super(handle);
    }

    public static TrustConstraints createDynamicObject(long handle) {
        return new TrustConstraints(handle);
    }

    public EnumSet<DataSource> getTrustSources() {
        int retVal = this.getTrustSourcesNative(this.getHandle());
        if (retVal == 0) {
            switch (TrustConstraints.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TrustConstraints.throwLastRuntimeException();
                }
            }
        }
        return TrustConstraints.getEnumSet(retVal, DataSource.class);
    }

    public void setTrustSources(EnumSet<DataSource> value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setTrustSourcesNative(this.getHandle(), TrustConstraints.getFlags(value));
        if (!retVal) {
            switch (TrustConstraints.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TrustConstraints.throwLastRuntimeException();
        }
    }

    public RevocationCheckPolicy getRevocationCheckPolicy() {
        int retVal = this.getRevocationCheckPolicyNative(this.getHandle());
        if (retVal == 0) {
            switch (TrustConstraints.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TrustConstraints.throwLastRuntimeException();
                }
            }
        }
        return RevocationCheckPolicy.fromValue(retVal);
    }

    public void setRevocationCheckPolicy(RevocationCheckPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setRevocationCheckPolicyNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (TrustConstraints.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TrustConstraints.throwLastRuntimeException();
        }
    }

    private native int getTrustSourcesNative(long var1);

    private native boolean setTrustSourcesNative(long var1, int var3);

    private native int getRevocationCheckPolicyNative(long var1);

    private native boolean setRevocationCheckPolicyNative(long var1, int var3);
}

