/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sys;

import com.pdftools.sys.Stream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileStream
implements Stream {
    private RandomAccessFile raFile = null;

    public FileStream(File file, Mode mode) throws IOException {
        this.raFile = new RandomAccessFile(file, mode.toString());
        if (mode == Mode.READ_WRITE_NEW) {
            this.raFile.setLength(0L);
        }
    }

    public FileStream(String filename, Mode mode) throws IOException {
        this(new File(filename), mode);
    }

    public FileStream(RandomAccessFile raFile) {
        this.raFile = raFile;
    }

    public RandomAccessFile GetRandomAccessFile() {
        return this.raFile;
    }

    @Override
    public long getLength() throws IOException {
        return this.raFile.length();
    }

    public void setLength(long length) throws IOException {
        this.raFile.setLength(length);
    }

    @Override
    public boolean seek(long position) throws IOException {
        if (position >= 0L) {
            this.raFile.seek(position);
        } else {
            this.raFile.seek(this.raFile.length());
        }
        return true;
    }

    @Override
    public long tell() throws IOException {
        return this.raFile.getFilePointer();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.raFile.read(buffer, offset, length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.raFile.write(buffer, offset, length);
    }

    public void copy(Stream stream) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = stream.read(buffer, 0, 8192)) > 0) {
            this.write(buffer, 0, read);
        }
    }

    @Override
    public void close() throws IOException {
        this.raFile.close();
    }

    public static enum Mode {
        READ_ONLY("r"),
        READ_WRITE_NEW("rw"),
        READ_WRITE_APPEND("rw"),
        READ_WRITE_S("rws"),
        READ_WRITE_D("rwd");

        private String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }
    }
}

