/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sys;

import com.pdftools.sys.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;

public class MemoryStream
implements Stream {
    private static final long MAX_MEMORY_SIZE = 0x80000000L;
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private LinkedList<byte[]> list = null;
    private long length = 0L;
    private long position = 0L;
    int blockSize;

    private MemoryStream(long initialCapacity, int blockSize) {
        this.blockSize = blockSize;
        this.list = new LinkedList();
        this.setMinCapacity(initialCapacity);
    }

    private MemoryStream(long initialCapacity) {
        this(initialCapacity, 8192);
    }

    public MemoryStream() {
        this(0L);
    }

    private MemoryStream(byte[] buffer, int offset, int length, int blockSize) {
        this(length, blockSize);
        this.write(buffer, offset, length);
    }

    public MemoryStream(byte[] buffer, int offset, int length) {
        this(buffer, offset, length, 8192);
    }

    public MemoryStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    private MemoryStream(Stream stream, int blockSize) throws IOException {
        this(stream.getLength(), blockSize);
        int read;
        byte[] buffer = new byte[blockSize];
        while ((read = stream.read(buffer, 0, blockSize)) > 0) {
            this.write(buffer, 0, read);
        }
    }

    public MemoryStream(Stream stream) throws IOException {
        this(stream, 8192);
    }

    public MemoryStream(InputStream inStream) throws IOException {
        this.initialize(inStream, 8192);
    }

    private void initialize(InputStream inStream, int blockSize) throws IOException {
        int read;
        this.blockSize = blockSize;
        this.list = new LinkedList();
        byte[] buffer = new byte[blockSize];
        while ((read = inStream.read(buffer)) > 0) {
            this.write(buffer, 0, read);
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean seek(long position) {
        this.position = position;
        return true;
    }

    @Override
    public long tell() {
        return this.position;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("'buffer'");
        }
        if (offset < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position == this.length) {
            return -1;
        }
        ListIterator<byte[]> it = this.list.listIterator((int)(this.position / (long)this.blockSize));
        int currPos = offset;
        while (length > 0 && it.hasNext() && this.position < this.length) {
            int blockPos = (int)(this.position % (long)this.blockSize);
            int currLength = Math.min(length, Math.min(this.blockSize - blockPos, (int)(this.length - this.position)));
            System.arraycopy(it.next(), blockPos, buffer, currPos, currLength);
            currPos += currLength;
            this.position += (long)currLength;
            length -= currLength;
        }
        int read = currPos - offset;
        return read;
    }

    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    public byte[] toByteArray() {
        if (this.length > 0x80000000L) {
            throw new OutOfMemoryError("Cannot allocate more than 2GB of memory.");
        }
        byte[] buffer = new byte[(int)this.length];
        ListIterator<byte[]> it = this.list.listIterator(0);
        int currPos = 0;
        while (it.hasNext()) {
            int currLength = Math.min(this.blockSize, (int)(this.length - (long)currPos));
            System.arraycopy(it.next(), 0, buffer, currPos, currLength);
            currPos += currLength;
        }
        return buffer;
    }

    public int transferFrom(InputStream inStream) throws IOException {
        int read;
        if (inStream == null) {
            throw new NullPointerException("'inStream'");
        }
        byte[] buffer = new byte[this.blockSize];
        int total = 0;
        while ((read = inStream.read(buffer)) > 0) {
            this.write(buffer, 0, read);
            total += read;
        }
        return total;
    }

    public long transferTo(OutputStream outStream) throws IOException {
        int read;
        if (outStream == null) {
            throw new NullPointerException("'outStream'");
        }
        byte[] buffer = new byte[this.blockSize];
        long total = 0L;
        while ((read = this.read(buffer)) > 0) {
            outStream.write(buffer, 0, read);
            total += (long)read;
        }
        return total;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("'buffer'");
        }
        if (offset < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.setMinLength(this.position + (long)length);
        ListIterator<byte[]> it = this.list.listIterator((int)(this.position / (long)this.blockSize));
        int currPos = offset;
        while (length > 0 && it.hasNext()) {
            int blockPos = (int)(this.position % (long)this.blockSize);
            int currLength = Math.min(length, this.blockSize - blockPos);
            System.arraycopy(buffer, currPos, it.next(), blockPos, currLength);
            currPos += currLength;
            this.position += (long)currLength;
            length -= currLength;
        }
    }

    @Override
    public void close() throws IOException {
    }

    private boolean setMinLength(long number) {
        if (number < 0L) {
            return false;
        }
        if (!this.setMinCapacity(number)) {
            return false;
        }
        if (this.length < number) {
            this.length = number;
        }
        return true;
    }

    private boolean setMinCapacity(long number) {
        if (number < 0L) {
            return false;
        }
        return this.setMinBlockNumber((int)((number + (long)this.blockSize - 1L) / (long)this.blockSize));
    }

    private boolean setMinBlockNumber(int number) {
        if (number < 0) {
            return false;
        }
        for (int change = number - this.list.size(); change > 0; --change) {
            this.list.addLast(new byte[this.blockSize]);
        }
        return true;
    }
}

