/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.domain;

import com.peluware.domain.Pagination;
import com.peluware.domain.Slice;
import com.peluware.domain.Sort;
import java.util.List;
import java.util.function.LongSupplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Page<T>
extends Slice<T> {
    private final long totalElements;

    public Page(@NotNull List<T> content, Pagination pagination, Sort sort, long totalElements) {
        super(content, pagination, sort);
        if (totalElements < (long)content.size()) {
            throw new IllegalArgumentException("Total elements must be greater than or equal to the size of the content.");
        }
        this.totalElements = totalElements;
    }

    public Page(@NotNull List<T> content, long totalElements) {
        this(content, Pagination.unpaginated(), Sort.unsorted(), totalElements);
    }

    public Page(@NotNull List<T> content) {
        this(content, content.size());
    }

    public int getTotalPages() {
        if (!this.getPagination().isPaginated()) {
            return 1;
        }
        int size = this.getPagination().size();
        return size == 0 ? 1 : (int)Math.ceil((double)this.totalElements / (double)size);
    }

    public static <T> Page<T> deferred(@NotNull List<T> content, Pagination pagination, Sort sort, @NotNull LongSupplier totalElementsSupplier) {
        if (pagination == null || !pagination.isPaginated()) {
            return new Page<T>(content, pagination, sort, content.size());
        }
        if (pagination.size() > content.size()) {
            if (pagination.offset() == 0) {
                return new Page<T>(content, pagination, sort, content.size());
            }
            if (!content.isEmpty()) {
                return new Page<T>(content, pagination, sort, totalElementsSupplier.getAsLong());
            }
        }
        return new Page<T>(content, pagination, sort, totalElementsSupplier.getAsLong());
    }

    public static <T> Page<T> deferred(@NotNull List<T> content, Pagination pagination, LongSupplier totalElementsSupplier) {
        return Page.deferred(content, pagination, Sort.unsorted(), totalElementsSupplier);
    }

    @Generated
    public long getTotalElements() {
        return this.totalElements;
    }
}

