/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.domain;

public record Pagination(Integer number, Integer size) {
    private static final Pagination UNPAGINATED = new Pagination(null, null);

    public boolean isPaginated() {
        return this.number != null && this.size != null && this.size > 0;
    }

    public int offset() {
        this.assertPaginated();
        return Math.max(0, this.number() * this.size());
    }

    public Pagination next() {
        this.assertPaginated();
        return new Pagination(this.number + 1, this.size);
    }

    public Pagination previous() {
        this.assertPaginated();
        if (this.number <= 0) {
            throw new UnsupportedOperationException("Cannot go to previous page from the first page");
        }
        return new Pagination(this.number - 1, this.size);
    }

    public Pagination first() {
        this.assertPaginated();
        return new Pagination(0, this.size);
    }

    public boolean hasPrevious() {
        this.assertPaginated();
        return this.number > 0;
    }

    private void assertPaginated() {
        if (!this.isPaginated()) {
            throw new UnsupportedOperationException("Pagination is not enabled");
        }
    }

    public static Pagination unpaginated() {
        return UNPAGINATED;
    }

    @Override
    public String toString() {
        return this.isPaginated() ? "Pagination[page=" + this.number + ", size=" + this.size + "]" : "Pagination[UNPAGINATED]";
    }
}

