/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.domain;

import com.peluware.domain.Order;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record Sort(Collection<Order> orders) implements Iterable<Order>
{
    private static final Sort UNSORTED = new Sort(Collections.emptyList());

    public boolean isSorted() {
        return !this.orders.isEmpty();
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Sort by(@NotNull String property, boolean ascending) {
        return Sort.by(new Order(property, ascending));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Sort by(Order ... orders) {
        return new Sort(List.of(orders));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Sort by(Collection<Order> orders) {
        return new Sort(List.copyOf(orders));
    }

    public static Sort unsorted() {
        return UNSORTED;
    }

    @Override
    @NotNull
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }
}

