/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.core.rsql;

import com.peluware.omnisearch.core.rsql.RsqlArgumentFormatException;
import com.peluware.omnisearch.core.rsql.RsqlArgumentParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRsqlArgumentParser
implements RsqlArgumentParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRsqlArgumentParser.class);
    private static DefaultRsqlArgumentParser instance = new DefaultRsqlArgumentParser();
    private static final List<DateTimeFormatter> DATE_FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("dd/MM/yyyy"), DateTimeFormatter.ofPattern("dd-MM-yyyy"), DateTimeFormatter.ofPattern("MM/dd/yyyy"));
    private static final List<DateTimeFormatter> DATETIME_FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"), DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"), DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
    private static final List<DateTimeFormatter> TIME_FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ofPattern("HH:mm:ss"), DateTimeFormatter.ofPattern("HH:mm"));
    protected final Map<Class<?>, Function<String, ?>> customParsers = new ConcurrentHashMap();

    public DefaultRsqlArgumentParser() {
        this.registerDefaultParsers();
    }

    @Override
    public <T> T parse(String argument, Class<T> type) throws RsqlArgumentFormatException, IllegalArgumentException {
        log.debug("Parsing argument ''{}'' as type {}", (Object)argument, (Object)type.getSimpleName());
        if (argument == null || argument.isBlank()) {
            return null;
        }
        argument = argument.trim();
        try {
            if (this.customParsers.containsKey(type)) {
                Object result = this.customParsers.get(type).apply(argument);
                return (T)result;
            }
            T result = this.parsePrimitiveAndWrapperTypes(argument, type);
            if (result != null) {
                return result;
            }
            result = this.parseTimeTypes(argument, type);
            if (result != null) {
                return result;
            }
            result = this.parseCommonTypes(argument, type);
            if (result != null) {
                return result;
            }
            if (type.isEnum()) {
                T enumValue = Enum.valueOf(type, argument);
                return enumValue;
            }
            return this.parseViaValueOf(argument, type);
        }
        catch (Exception e) {
            log.info("Failed to parse argument ''{}'' as {}: {}", new Object[]{argument, type.getSimpleName(), e.getMessage()});
            throw new RsqlArgumentFormatException(argument, type);
        }
    }

    @Override
    public <T> List<T> parse(List<String> arguments, Class<T> type) throws RsqlArgumentFormatException, IllegalArgumentException {
        ArrayList<T> result = new ArrayList<T>(arguments.size());
        for (String argument : arguments) {
            result.add(this.parse(argument, type));
        }
        return result;
    }

    private <T> T parsePrimitiveAndWrapperTypes(String argument, Class<T> type) {
        if (type.equals(String.class)) {
            return (T)argument;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(argument);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(argument);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(argument);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(argument);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(argument);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(argument);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.valueOf(argument);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            if (argument.length() != 1) {
                throw new IllegalArgumentException("Character argument must be exactly one character");
            }
            return (T)Character.valueOf(argument.charAt(0));
        }
        if (type.equals(BigDecimal.class)) {
            return (T)new BigDecimal(argument);
        }
        if (type.equals(BigInteger.class)) {
            return (T)new BigInteger(argument);
        }
        return null;
    }

    private <T> T parseTimeTypes(String argument, Class<T> type) {
        if (type.equals(LocalDate.class)) {
            return (T)this.parseLocalDate(argument);
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)this.parseLocalDateTime(argument);
        }
        if (type.equals(LocalTime.class)) {
            return (T)this.parseLocalTime(argument);
        }
        if (type.equals(Instant.class)) {
            return (T)this.parseInstant(argument);
        }
        if (type.equals(ZonedDateTime.class)) {
            return (T)ZonedDateTime.parse(argument);
        }
        if (type.equals(OffsetDateTime.class)) {
            return (T)OffsetDateTime.parse(argument);
        }
        if (type.equals(OffsetTime.class)) {
            return (T)OffsetTime.parse(argument);
        }
        if (type.equals(Duration.class)) {
            return (T)Duration.parse(argument);
        }
        if (type.equals(Period.class)) {
            return (T)Period.parse(argument);
        }
        if (type.equals(Date.class)) {
            LocalDateTime dateTime = this.parseLocalDateTime(argument);
            return (T)Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    private <T> T parseCommonTypes(String argument, Class<T> type) {
        if (type.equals(UUID.class)) {
            return (T)UUID.fromString(argument);
        }
        if (type.equals(byte[].class)) {
            return (T)argument.getBytes();
        }
        if (type.isArray()) {
            return this.parseArray(argument, type);
        }
        return null;
    }

    private <T> T parseArray(String argument, Class<T> type) {
        Class<?> componentType = type.getComponentType();
        String[] parts = argument.split(",");
        if (componentType.equals(String.class)) {
            return (T)parts;
        }
        if (componentType.equals(Integer.class) || componentType.equals(Integer.TYPE)) {
            Integer[] result = new Integer[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Integer.valueOf(parts[i].trim());
            }
            return (T)result;
        }
        return null;
    }

    private <T> T parseViaValueOf(String argument, Class<T> type) {
        try {
            Method method = type.getMethod("valueOf", String.class);
            Object result = method.invoke(null, argument);
            return (T)result;
        }
        catch (InvocationTargetException e) {
            throw new RsqlArgumentFormatException(argument, type);
        }
        catch (ReflectiveOperationException e) {
            log.warn("{} does not have method valueOf(String s) or method is inaccessible", type);
            throw new IllegalArgumentException("Cannot parse argument type " + String.valueOf(type));
        }
    }

    private LocalDate parseLocalDate(String argument) {
        for (DateTimeFormatter formatter : DATE_FORMATTERS) {
            try {
                return LocalDate.parse(argument, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeParseException("Unable to parse LocalDate: " + argument, argument, 0);
    }

    private LocalDateTime parseLocalDateTime(String argument) {
        for (DateTimeFormatter formatter : DATETIME_FORMATTERS) {
            try {
                return LocalDateTime.parse(argument, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        try {
            LocalDate date = this.parseLocalDate(argument);
            return date.atStartOfDay();
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new DateTimeParseException("Unable to parse LocalDateTime: " + argument, argument, 0);
        }
    }

    private LocalTime parseLocalTime(String argument) {
        for (DateTimeFormatter formatter : TIME_FORMATTERS) {
            try {
                return LocalTime.parse(argument, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeParseException("Unable to parse LocalTime: " + argument, argument, 0);
    }

    private Instant parseInstant(String argument) {
        try {
            return Instant.parse(argument);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                long epochMilli = Long.parseLong(argument);
                return Instant.ofEpochMilli(epochMilli);
            }
            catch (NumberFormatException epochMilli) {
                try {
                    long epochSecond = Long.parseLong(argument);
                    return Instant.ofEpochSecond(epochSecond);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DateTimeParseException("Unable to parse Instant: " + argument, argument, 0);
                }
            }
        }
    }

    protected void registerDefaultParsers() {
    }

    public <T> void addCustomParser(Class<T> type, Function<String, T> parser) {
        this.customParsers.put(type, parser);
        log.debug("Added custom parser for type: {}", (Object)type.getSimpleName());
    }

    public void removeCustomParser(Class<?> type) {
        this.customParsers.remove(type);
        log.debug("Removed custom parser for type: {}", (Object)type.getSimpleName());
    }

    public boolean hasCustomParser(Class<?> type) {
        return this.customParsers.containsKey(type);
    }

    public Set<Class<?>> getCustomParserTypes() {
        return Collections.unmodifiableSet(this.customParsers.keySet());
    }

    @Generated
    public static DefaultRsqlArgumentParser getInstance() {
        return instance;
    }

    @Generated
    public static void setInstance(DefaultRsqlArgumentParser instance) {
        DefaultRsqlArgumentParser.instance = instance;
    }
}

