/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.jpa;

import com.peluware.omnisearch.core.EnumSearchCandidate;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.ParseNumber;
import com.peluware.omnisearch.jpa.JpaOmniSearchPredicateBuilder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJpaOmniSearchPredicateBuilder
implements JpaOmniSearchPredicateBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJpaOmniSearchPredicateBuilder.class);
    protected static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    protected <E> Predicate searchInAllColumns(@NotNull String search, Root<E> root, EntityManager em, Set<String> joinColumns) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(this.getSearchPredicates(search, (Path<?>)root, em));
        ManagedType managedType = em.getMetamodel().managedType(root.getJavaType());
        for (String joinColumn : joinColumns) {
            if (!managedType.getAttribute(joinColumn).isAssociation()) {
                log.trace("Join column '{}' is not an association in {}", (Object)joinColumn, (Object)managedType.getJavaType().getName());
                continue;
            }
            Join join = root.join(joinColumn, JoinType.LEFT);
            predicates.addAll(this.getSearchPredicates(search, (Path<?>)join, em));
        }
        CriteriaBuilder cb = em.getCriteriaBuilder();
        return cb.or((Predicate[])predicates.toArray(Predicate[]::new));
    }

    protected Collection<Predicate> getSearchPredicates(String search, Path<?> path, EntityManager em) {
        Class javaType = path.getJavaType();
        ManagedType managedType = em.getMetamodel().managedType(javaType);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Attribute attribute : managedType.getAttributes()) {
            try {
                Predicate basicPredicate;
                String propertyName = attribute.getName();
                Attribute.PersistentAttributeType type = attribute.getPersistentAttributeType();
                if (type == Attribute.PersistentAttributeType.BASIC) {
                    basicPredicate = this.getBasicPredicates(search, path.get(propertyName), em);
                    if (basicPredicate == null) continue;
                    predicates.add(basicPredicate);
                    continue;
                }
                if (type == Attribute.PersistentAttributeType.EMBEDDED) {
                    predicates.addAll(this.getSearchPredicates(search, path.get(propertyName), em));
                    continue;
                }
                if (type != Attribute.PersistentAttributeType.ELEMENT_COLLECTION || !(attribute instanceof PluralAttribute)) continue;
                PluralAttribute plural = (PluralAttribute)attribute;
                if (!(path instanceof From)) continue;
                From from = (From)path;
                if (plural.getElementType().getPersistenceType() != Type.PersistenceType.BASIC || (basicPredicate = this.getBasicPredicates(search, (Path<?>)from.join(propertyName, JoinType.LEFT), em)) == null) continue;
                predicates.add(basicPredicate);
            }
            catch (IllegalArgumentException e) {
                log.trace("Could not parse search value '{}' for attribute '{}': {}", new Object[]{search, attribute.getName(), e.getMessage()});
            }
            catch (Exception e) {
                log.trace("Could not create predicate for attribute '{}': {}", (Object)attribute.getName(), (Object)e.getMessage());
            }
        }
        return predicates;
    }

    @Nullable
    protected Predicate getBasicPredicates(String search, Path<?> path, EntityManager em) {
        Class type = path.getJavaType();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        if (String.class.isAssignableFrom(type)) {
            return cb.like(cb.lower(path.as(String.class)), "%" + search.toLowerCase() + "%");
        }
        if (UUID.class.isAssignableFrom(type) && UUID_PATTERN.matcher(search).matches()) {
            return cb.equal(path, (Object)UUID.fromString(search));
        }
        if ((Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) && search.matches("true|false")) {
            return cb.equal(path, (Object)Boolean.parseBoolean(search));
        }
        if (Year.class.isAssignableFrom(type) && search.matches("\\d{4}")) {
            return cb.equal(path, (Object)Year.parse(search));
        }
        if (type.isEnum()) {
            Collection candidates = EnumSearchCandidate.collectEnumCandidates((Class)type, (String)search);
            if (candidates.isEmpty()) {
                return null;
            }
            return path.in(candidates);
        }
        if ((Number.class.isAssignableFrom(type) || type.isPrimitive()) && search.matches("[+-]?\\d*\\.?\\d+")) {
            for (ParseNumber.Parser parser : ParseNumber.PARSERS) {
                if (!type.isAssignableFrom(parser.type())) continue;
                return cb.equal(path, parser.parse(search));
            }
        }
        return null;
    }

    public <M> Predicate buildPredicate(EntityManager em, Root<M> root, OmniSearchBaseOptions options) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        Predicate predicate = cb.conjunction();
        String search = options.getSearch();
        if (search != null && !search.isBlank()) {
            predicate = this.searchInAllColumns(search, root, em, options.getPropagations());
        }
        return predicate;
    }
}

