/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.jpa;

import com.peluware.domain.Pagination;
import com.peluware.domain.Sort;
import com.peluware.omnisearch.core.OmniSearch;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.OmniSearchOptions;
import com.peluware.omnisearch.jpa.JpaOmniSearchPredicateBuilder;
import com.peluware.omnisearch.jpa.rsql.JpaPredicateVisitor;
import com.peluware.omnisearch.jpa.rsql.RsqlJpaBuilderOptions;
import cz.jirutka.rsql.parser.ast.Node;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaOmniSearch
implements OmniSearch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaOmniSearch.class);
    private final EntityManager em;
    private final RsqlJpaBuilderOptions rsqlBuilderTools;
    private JpaOmniSearchPredicateBuilder predicateBuilder = JpaOmniSearchPredicateBuilder.DEFAULT;

    public JpaOmniSearch(EntityManager em) {
        this(em, RsqlJpaBuilderOptions.DEFAULT);
    }

    public JpaOmniSearch(EntityManager em, RsqlJpaBuilderOptions rsqlBuilderTools) {
        this.em = em;
        this.rsqlBuilderTools = rsqlBuilderTools;
    }

    public <E> List<E> search(Class<E> entityClass, OmniSearchOptions options) {
        Pagination pagination;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(entityClass);
        Root root = query.from(entityClass);
        Predicate predicate = this.buildPredicate(root, cb, (OmniSearchBaseOptions)options);
        query.where((Expression)predicate);
        Sort sort = options.getSort();
        if (sort.isSorted()) {
            query.orderBy(sort.orders().stream().map(order -> {
                Path path = root.get(order.property());
                return order.ascending() ? cb.asc((Expression)path) : cb.desc((Expression)path);
            }).toList());
        }
        if (!(pagination = options.getPagination()).isPaginated()) {
            return this.em.createQuery(query).getResultList();
        }
        return this.em.createQuery(query).setFirstResult(pagination.offset()).setMaxResults(pagination.size().intValue()).getResultList();
    }

    public <E> long count(Class<E> entityClass, OmniSearchBaseOptions options) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(entityClass);
        Predicate predicate = this.buildPredicate(root, cb, options);
        query.where((Expression)predicate);
        query.select((Selection)cb.count((Expression)root));
        return (Long)this.em.createQuery(query).getSingleResult();
    }

    public <E> Predicate buildPredicate(Root<E> root, CriteriaBuilder cb, OmniSearchBaseOptions options) {
        Predicate predicate = this.predicateBuilder.buildPredicate(this.em, root, options);
        Node query = options.getQuery();
        if (query != null) {
            JpaPredicateVisitor<E> visitor = new JpaPredicateVisitor<E>(root, this.rsqlBuilderTools);
            Predicate filtersPredicate = (Predicate)query.accept(visitor, (Object)this.em);
            predicate = cb.and((Expression)predicate, (Expression)filtersPredicate);
        }
        return predicate;
    }

    @Generated
    public void setPredicateBuilder(JpaOmniSearchPredicateBuilder predicateBuilder) {
        this.predicateBuilder = predicateBuilder;
    }
}

