/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.jpa.rsql;

import com.peluware.omnisearch.core.rsql.RsqlUnknowComparisionOperatorException;
import com.peluware.omnisearch.jpa.rsql.RsqlJpaComparisionPredicateBuilder;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRsqlJpaComparisionPredicateBuilder
implements RsqlJpaComparisionPredicateBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRsqlJpaComparisionPredicateBuilder.class);
    public static final Character LIKE_WILDCARD = Character.valueOf('*');
    protected static final Date START_DATE;
    protected static final Date END_DATE;

    @Override
    public Predicate buildComparisionPredicate(Expression<?> propertyPath, ComparisonOperator operator, List<?> arguments, EntityManager manager) throws RsqlUnknowComparisionOperatorException {
        log.trace("Creating predicate: propertyPath {} {}", (Object)operator, arguments);
        if (RSQLOperators.EQUAL.equals((Object)operator)) {
            return this.equalPredicate(propertyPath, arguments, manager);
        }
        if (RSQLOperators.NOT_EQUAL.equals((Object)operator)) {
            return this.notEqualPredicate(propertyPath, arguments, manager);
        }
        if (RSQLOperators.GREATER_THAN.equals((Object)operator)) {
            return this.greaterThanPredicate(propertyPath, operator, arguments, manager);
        }
        if (RSQLOperators.GREATER_THAN_OR_EQUAL.equals((Object)operator)) {
            return this.greaterThanOrEqualPredicate(propertyPath, operator, manager, arguments);
        }
        if (RSQLOperators.LESS_THAN.equals((Object)operator)) {
            return this.lessThanPredicate(propertyPath, operator, arguments, manager);
        }
        if (RSQLOperators.LESS_THAN_OR_EQUAL.equals((Object)operator)) {
            return this.lessThanOrEqualPredicate(propertyPath, operator, arguments, manager);
        }
        if (RSQLOperators.IN.equals((Object)operator)) {
            return this.createIn(propertyPath, arguments);
        }
        if (RSQLOperators.NOT_IN.equals((Object)operator)) {
            return this.createNotIn(propertyPath, arguments, manager);
        }
        throw new RsqlUnknowComparisionOperatorException(operator);
    }

    private Predicate lessThanOrEqualPredicate(Expression<?> propertyPath, ComparisonOperator operator, List<?> arguments, EntityManager manager) {
        Object argument = arguments.getFirst();
        if (argument instanceof Date) {
            Date casted = (Date)argument;
            return this.createBetweenThan(propertyPath, START_DATE, casted, manager);
        }
        if (argument instanceof Number) {
            Number casted = (Number)argument;
            return this.createLessEqual(propertyPath, casted, manager);
        }
        if (argument instanceof Comparable) {
            Comparable casted = (Comparable)argument;
            return this.createLessEqualComparable(propertyPath, casted, manager);
        }
        throw new IllegalArgumentException(this.buildNotComparableMessage(operator, argument));
    }

    private Predicate lessThanPredicate(Expression<?> propertyPath, ComparisonOperator operator, List<?> arguments, EntityManager manager) {
        Object argument = arguments.getFirst();
        if (argument instanceof Date) {
            Date casted = (Date)argument;
            int days = -1;
            return this.createBetweenThan(propertyPath, START_DATE, this.modifyDate(casted, days), manager);
        }
        if (argument instanceof Number) {
            Number casted = (Number)argument;
            return this.createLessThan(propertyPath, casted, manager);
        }
        if (argument instanceof Comparable) {
            Comparable casted = (Comparable)argument;
            return this.createLessThanComparable(propertyPath, casted, manager);
        }
        throw new IllegalArgumentException(this.buildNotComparableMessage(operator, argument));
    }

    private Predicate greaterThanOrEqualPredicate(Expression<?> propertyPath, ComparisonOperator operator, EntityManager manager, List<?> arguments) {
        Object argument = arguments.getFirst();
        if (argument instanceof Date) {
            Date casted = (Date)argument;
            return this.createBetweenThan(propertyPath, casted, END_DATE, manager);
        }
        if (argument instanceof Number) {
            Number casted = (Number)argument;
            return this.createGreaterEqual(propertyPath, casted, manager);
        }
        if (argument instanceof Comparable) {
            Comparable casted = (Comparable)argument;
            return this.createGreaterEqualComparable(propertyPath, casted, manager);
        }
        throw new IllegalArgumentException(this.buildNotComparableMessage(operator, argument));
    }

    private Predicate greaterThanPredicate(Expression<?> propertyPath, ComparisonOperator operator, List<?> arguments, EntityManager manager) {
        Object argument = arguments.getFirst();
        if (argument instanceof Date) {
            Date casted = (Date)argument;
            int days = 1;
            return this.createBetweenThan(propertyPath, this.modifyDate(casted, days), END_DATE, manager);
        }
        if (argument instanceof Number) {
            Number casted = (Number)argument;
            return this.createGreaterThan(propertyPath, casted, manager);
        }
        if (argument instanceof Comparable) {
            Comparable casted = (Comparable)argument;
            return this.createGreaterThanComparable(propertyPath, casted, manager);
        }
        throw new IllegalArgumentException(this.buildNotComparableMessage(operator, argument));
    }

    protected Predicate notEqualPredicate(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        Object argument = arguments.getFirst();
        if (argument instanceof String) {
            String casted = (String)argument;
            return this.createNotLike(propertyPath, casted, manager);
        }
        if (this.isNullArgument(argument)) {
            return this.createIsNotNull(propertyPath, manager);
        }
        return this.createNotEqual(propertyPath, argument, manager);
    }

    protected Predicate equalPredicate(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        Object argument = arguments.getFirst();
        if (argument instanceof String) {
            String casted = (String)argument;
            return this.createLike(propertyPath, casted, manager);
        }
        if (this.isNullArgument(argument)) {
            return this.createIsNull(propertyPath, manager);
        }
        return this.createEqual(propertyPath, argument, manager);
    }

    protected Predicate createBetweenThan(Expression<? extends Date> propertyPath, Date start, Date end, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.between(propertyPath, (Comparable)start, (Comparable)end);
    }

    protected Predicate createLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        String like = argument.replace(LIKE_WILDCARD.charValue(), '%');
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.like(builder.lower(propertyPath), like.toLowerCase());
    }

    protected Predicate createIsNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNull(propertyPath);
    }

    protected Predicate createEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.equal(propertyPath, argument);
    }

    protected Predicate createNotEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.notEqual(propertyPath, argument);
    }

    protected Predicate createNotLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)this.createLike(propertyPath, argument, manager));
    }

    protected Predicate createIsNotNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNotNull(propertyPath);
    }

    protected Predicate createGreaterThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.gt(propertyPath, argument);
    }

    protected <Y extends Comparable<? super Y>> Predicate createGreaterThanComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.greaterThan(propertyPath, argument);
    }

    protected Predicate createGreaterEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.ge(propertyPath, argument);
    }

    protected <Y extends Comparable<? super Y>> Predicate createGreaterEqualComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.greaterThanOrEqualTo(propertyPath, argument);
    }

    protected Predicate createLessThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lt(propertyPath, argument);
    }

    protected <Y extends Comparable<? super Y>> Predicate createLessThanComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lessThan(propertyPath, argument);
    }

    protected Predicate createLessEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.le(propertyPath, argument);
    }

    protected <Y extends Comparable<? super Y>> Predicate createLessEqualComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lessThanOrEqualTo(propertyPath, argument);
    }

    protected Predicate createIn(Expression<?> propertyPath, List<?> arguments) {
        return propertyPath.in(arguments);
    }

    protected Predicate createNotIn(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)this.createIn(propertyPath, arguments));
    }

    protected boolean isNullArgument(Object argument) {
        return argument == null;
    }

    protected Date modifyDate(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        date = c.getTime();
        return date;
    }

    protected String buildNotComparableMessage(ComparisonOperator operator, Object argument) {
        return String.format("Invalid type for comparison operator: %s type: %s must implement Comparable<%s>", operator, argument.getClass().getName(), argument.getClass().getSimpleName());
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        END_DATE = cal.getTime();
        cal.set(5, 0, 1);
        START_DATE = cal.getTime();
    }
}

