/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.jpa.rsql;

import com.peluware.omnisearch.core.rsql.RsqlArgumentParser;
import com.peluware.omnisearch.jpa.rsql.AbstractJpaVisitor;
import com.peluware.omnisearch.jpa.rsql.RsqlJpaBuilderOptions;
import com.peluware.omnisearch.jpa.rsql.RsqlJpaComparisionPredicateBuilder;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.LogicalOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPredicateVisitor<T>
extends AbstractJpaVisitor<Predicate, T>
implements RSQLVisitor<Predicate, EntityManager> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaPredicateVisitor.class);
    private final Root<T> root;

    public JpaPredicateVisitor(Root<T> root, RsqlJpaBuilderOptions builderTools) {
        super(root.getJavaType(), builderTools);
        this.root = root;
    }

    public Predicate visit(AndNode node, EntityManager entityManager) {
        log.debug("Creating Predicate for AndNode: {}", (Object)node);
        return this.visitLogicalNode((LogicalNode)node, entityManager);
    }

    public Predicate visit(OrNode node, EntityManager entityManager) {
        log.debug("Creating Predicate for OrNode: {}", (Object)node);
        return this.visitLogicalNode((LogicalNode)node, entityManager);
    }

    private Predicate visitLogicalNode(LogicalNode node, EntityManager entityManager) {
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        List children = node.getChildren();
        if (children.isEmpty()) {
            return cb.disjunction();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Node childNode : children) {
            predicates.add((Predicate)childNode.accept((RSQLVisitor)this, (Object)entityManager));
        }
        return switch (node.getOperator()) {
            default -> throw new MatchException(null, null);
            case LogicalOperator.OR -> cb.or(predicates.toArray(new Predicate[0]));
            case LogicalOperator.AND -> cb.and(predicates.toArray(new Predicate[0]));
        };
    }

    public Predicate visit(ComparisonNode node, EntityManager entityManager) {
        log.debug("Creating Predicate for ComparisonNode: {}", (Object)node);
        RsqlArgumentParser argumentParser = this.builderOptions.getArgumentParser();
        Path<T> path = this.findPath(node.getSelector(), (Path<?>)this.root, entityManager);
        Class type = path.getModel().getBindableJavaType();
        log.trace("Cast all arguments to type {}.", (Object)type.getName());
        List castedArguments = argumentParser.parse(node.getArguments(), type);
        RsqlJpaComparisionPredicateBuilder comparisionPredicateBuilder = this.builderOptions.getComparisionPredicateBuilder();
        return comparisionPredicateBuilder.buildComparisionPredicate((Expression<?>)path, node.getOperator(), castedArguments, entityManager);
    }

    public Path<?> findPath(String path, Path<?> startRoot, EntityManager entityManager) {
        String[] graph = path.split("\\.");
        Metamodel metaModel = entityManager.getMetamodel();
        ManagedType classMetadata = metaModel.managedType(startRoot.getJavaType());
        Join currentRoot = startRoot;
        int graphLength = graph.length;
        for (int i = 0; i < graphLength; ++i) {
            String attribute = graph[i];
            if (!this.hasAttribute(attribute, classMetadata)) {
                throw new IllegalArgumentException("Unknown property: " + attribute + " From<?,?> entity " + classMetadata.getJavaType().getName());
            }
            Attribute jpaAttribute = classMetadata.getAttribute(attribute);
            Attribute.PersistentAttributeType persistentAttributeType = jpaAttribute.getPersistentAttributeType();
            Class<?> type = this.getSingularType(jpaAttribute);
            if (jpaAttribute.isAssociation()) {
                classMetadata = metaModel.managedType(type);
                currentRoot = ((From)currentRoot).join(attribute);
                continue;
            }
            if (persistentAttributeType == Attribute.PersistentAttributeType.EMBEDDED) {
                classMetadata = metaModel.embeddable(type);
                currentRoot = currentRoot.get(attribute);
                continue;
            }
            if (persistentAttributeType == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                currentRoot = ((From)currentRoot).join(attribute);
                if (i == graphLength - 1) continue;
                throw new IllegalArgumentException("ElementCollection must be the last part of the path: " + path);
            }
            if (persistentAttributeType != Attribute.PersistentAttributeType.BASIC) continue;
            currentRoot = currentRoot.get(attribute);
            if (i == graphLength - 1) continue;
            throw new IllegalArgumentException("Basic attribute must be the last part of the path: " + path);
        }
        return currentRoot;
    }

    protected <E> boolean hasAttribute(String property, ManagedType<E> classMetadata) {
        Set names = classMetadata.getAttributes();
        for (Attribute name : names) {
            if (!name.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    protected Class<?> getSingularType(Attribute<?, ?> property) {
        if (property.isCollection()) {
            return ((PluralAttribute)property).getBindableJavaType();
        }
        return property.getJavaType();
    }
}

