/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb;

import com.mongodb.client.model.Filters;
import com.peluware.omnisearch.core.EnumSearchCandidate;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.ParseNumber;
import com.peluware.omnisearch.mongodb.MongoOmniSearchFilterBuilder;
import com.peluware.omnisearch.mongodb.ReflectionUtils;
import com.peluware.omnisearch.mongodb.resolvers.PropertyNameResolver;
import java.lang.reflect.Field;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMongoOmniSearchFilterBuilder
implements MongoOmniSearchFilterBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMongoOmniSearchFilterBuilder.class);
    protected static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    protected static final Pattern OBJECT_ID_PATTERN = Pattern.compile("^[0-9a-fA-F]{24}$");
    private static final Map<Class<?>, List<Field>> BASIC_FIELDS = new ConcurrentHashMap();
    private static final Map<Class<?>, List<Field>> COMPLEX_FIELDS = new ConcurrentHashMap();

    protected static List<Field> getBasicFields(Class<?> clazz) {
        return BASIC_FIELDS.computeIfAbsent(clazz, c -> Arrays.stream(c.getDeclaredFields()).filter(field -> ReflectionUtils.isBasicField(field, clazz) || ReflectionUtils.isBasicCompositeField(field, clazz)).toList());
    }

    protected static List<Field> getComplexFields(Class<?> clazz) {
        return COMPLEX_FIELDS.computeIfAbsent(clazz, c -> Arrays.stream(c.getDeclaredFields()).filter(field -> !ReflectionUtils.isBasicField(field, clazz) && !ReflectionUtils.isBasicCompositeField(field, clazz)).toList());
    }

    @Override
    public <D> Bson buildFilter(Class<D> documentClass, OmniSearchBaseOptions options) {
        Document filters = new Document();
        String search = options.getSearch();
        if (search != null && !search.isBlank()) {
            filters = this.searchInAllProperties(search, documentClass, options.getPropagations());
        }
        return filters;
    }

    private <D> Bson searchInAllProperties(String search, Class<D> documentClass, Set<String> propagations) {
        ArrayList<Bson> searchFilters = new ArrayList<Bson>(this.getSearchFilters(search, documentClass, ""));
        for (String path : propagations) {
            Field field = DefaultMongoOmniSearchFilterBuilder.getComplexFields(documentClass).stream().filter(f -> f.getName().equals(path)).findFirst().orElseThrow(() -> new IllegalArgumentException("Propagation path '" + path + "' not found in class " + documentClass.getName()));
            Class<?> fieldType = field.getType();
            String pathName = PropertyNameResolver.resolvePropertyName(field);
            searchFilters.addAll(this.getSearchFilters(search, fieldType, pathName + "."));
        }
        return Filters.or(searchFilters);
    }

    protected <D> Collection<Bson> getSearchFilters(String search, Class<D> clazz, String prefix) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        for (Field field : DefaultMongoOmniSearchFilterBuilder.getBasicFields(clazz)) {
            try {
                Class<?> elementType;
                Bson basicFilter;
                String originalPropertyName = PropertyNameResolver.resolvePropertyName(field);
                String propertyName = prefix + originalPropertyName;
                Bson basicPredicates = DefaultMongoOmniSearchFilterBuilder.getBasicPredicates(search, field.getType(), propertyName);
                if (basicPredicates != null) {
                    log.trace("Basic predicate created for property '{}' with value '{}'", (Object)propertyName, (Object)search);
                    filters.add(basicPredicates);
                    continue;
                }
                Class<?> fieldType = field.getType();
                if (!fieldType.isArray() && !Collection.class.isAssignableFrom(fieldType) || (basicFilter = DefaultMongoOmniSearchFilterBuilder.getBasicPredicates(search, elementType = ReflectionUtils.resolveComponentFieldType(field, clazz), propertyName)) == null) continue;
                log.trace("Basic predicate created for array/collection property '{}' with value '{}'", (Object)propertyName, (Object)search);
                filters.add(basicFilter);
            }
            catch (IllegalArgumentException e) {
                log.trace("Could not parse search value '{}' for property '{}': {}", new Object[]{search, field.getName(), e.getMessage()});
            }
            catch (Exception e) {
                log.trace("Could not create filter for property '{}': {}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        return filters;
    }

    @Nullable
    protected static Bson getBasicPredicates(String search, Class<?> type, String property) {
        if (String.class.isAssignableFrom(type)) {
            Pattern pattern = Pattern.compile(Pattern.quote(search), 2);
            return Filters.regex((String)property, (Pattern)pattern);
        }
        if (UUID.class.isAssignableFrom(type) && UUID_PATTERN.matcher(search).matches()) {
            return Filters.eq((String)property, (Object)UUID.fromString(search));
        }
        if ((Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) && search.matches("(?i)true|false")) {
            return Filters.eq((String)property, (Object)Boolean.parseBoolean(search.toLowerCase()));
        }
        if (Year.class.isAssignableFrom(type) && search.matches("\\d{4}")) {
            return Filters.eq((String)property, (Object)Year.parse(search));
        }
        if (ObjectId.class.isAssignableFrom(type) && OBJECT_ID_PATTERN.matcher(search).matches()) {
            return Filters.eq((String)property, (Object)new ObjectId(search));
        }
        if (type.isEnum()) {
            Collection candidates = EnumSearchCandidate.collectEnumCandidates(type, (String)search);
            if (candidates.isEmpty()) {
                return null;
            }
            return Filters.in((String)property, (Iterable)candidates);
        }
        if ((Number.class.isAssignableFrom(type) || type.isPrimitive()) && search.matches("[+-]?\\d*\\.?\\d+")) {
            for (ParseNumber.Parser parser : ParseNumber.PARSERS) {
                if (!type.isAssignableFrom(parser.type())) continue;
                return Filters.eq((String)property, (Object)((Number)parser.parse(search)));
            }
        }
        return null;
    }
}

