/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.peluware.domain.Order;
import com.peluware.domain.Pagination;
import com.peluware.domain.Sort;
import com.peluware.omnisearch.core.OmniSearch;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.OmniSearchOptions;
import com.peluware.omnisearch.mongodb.MongoOmniSearchFilterBuilder;
import com.peluware.omnisearch.mongodb.resolvers.CollectionNameResolver;
import com.peluware.omnisearch.mongodb.rsql.MongoFilterVisitor;
import com.peluware.omnisearch.mongodb.rsql.RsqlMongoBuilderOptions;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoOmniSearch
implements OmniSearch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoOmniSearch.class);
    private final MongoDatabase database;
    private final RsqlMongoBuilderOptions rsqlBuilderOptions;
    private MongoOmniSearchFilterBuilder filterBuilder = MongoOmniSearchFilterBuilder.DEFAULT;

    public MongoOmniSearch(MongoDatabase database) {
        this(database, RsqlMongoBuilderOptions.DEFAULT);
    }

    public <E> List<E> search(Class<E> entityClass, OmniSearchOptions options) {
        Pagination pagination;
        String collectionName = CollectionNameResolver.resolveCollectionName(entityClass);
        MongoCollection collection = this.database.getCollection(collectionName, entityClass);
        Bson filter = this.buildFilter(entityClass, (OmniSearchBaseOptions)options);
        FindIterable findIterable = collection.find(filter);
        this.debugJsonFilter(filter);
        Sort sort = options.getSort();
        if (sort.isSorted()) {
            Document sortDocument = new Document();
            for (Order order : sort.orders()) {
                sortDocument.append(order.property(), (Object)(order.ascending() ? 1 : -1));
            }
            findIterable = findIterable.sort((Bson)sortDocument);
        }
        if ((pagination = options.getPagination()).isPaginated()) {
            findIterable = findIterable.skip(pagination.offset()).limit(pagination.size().intValue());
        }
        return Collections.unmodifiableList((List)findIterable.into(new ArrayList()));
    }

    public <E> long count(Class<E> entityClass, OmniSearchBaseOptions options) {
        String collectionName = CollectionNameResolver.resolveCollectionName(entityClass);
        MongoCollection collection = this.database.getCollection(collectionName, entityClass);
        Bson filter = this.buildFilter(entityClass, options);
        this.debugJsonFilter(filter);
        log.debug("Executing MongoDB count query: {} for entity: {}", (Object)filter, (Object)entityClass.getSimpleName());
        return collection.countDocuments(filter);
    }

    public <E> Bson buildFilter(Class<E> entityClass, OmniSearchBaseOptions options) {
        Bson filter = this.filterBuilder.buildFilter(entityClass, options);
        Node query = options.getQuery();
        if (query != null) {
            Bson rsqlFilter = (Bson)query.accept(new MongoFilterVisitor<E>(entityClass, this.rsqlBuilderOptions), null);
            filter = Filters.and((Bson[])new Bson[]{filter, rsqlFilter});
        }
        return filter;
    }

    private void debugJsonFilter(Bson filter) {
        if (log.isDebugEnabled()) {
            JsonWriterSettings settings = JsonWriterSettings.builder().indent(true).build();
            log.debug("Filter (JSON): {}", (Object)filter.toBsonDocument(BsonDocument.class, this.database.getCodecRegistry()).toJson(settings));
        }
    }

    @Generated
    public MongoOmniSearch(MongoDatabase database, RsqlMongoBuilderOptions rsqlBuilderOptions) {
        this.database = database;
        this.rsqlBuilderOptions = rsqlBuilderOptions;
    }

    @Generated
    public void setFilterBuilder(MongoOmniSearchFilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
    }
}

