/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Year;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Class<?> resolveComponentFieldType(Field field, Class<?> contextClass) {
        Type genericType;
        Class<?> type = ReflectionUtils.resolveFieldType(field, contextClass);
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Map typeArgs = TypeUtils.getTypeArguments(contextClass, field.getDeclaringClass());
            Type resolved = TypeUtils.unrollVariables((Map)typeArgs, (Type)paramType.getActualTypeArguments()[0]);
            if (resolved instanceof Class) {
                Class classType = (Class)resolved;
                return classType;
            }
        }
        throw new IllegalArgumentException("Field is not a collection or array: " + field.getName() + " of type " + type.getName());
    }

    public static boolean isBasicType(Class<?> type) {
        return String.class.isAssignableFrom(type) || UUID.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Year.class.isAssignableFrom(type) || ObjectId.class.isAssignableFrom(type) || type.isPrimitive() || type.isEnum();
    }

    public static boolean isBasicField(Field field, Class<?> contextClass) {
        try {
            Class<?> resolvedType = ReflectionUtils.resolveFieldType(field, contextClass);
            return ReflectionUtils.isBasicType(resolvedType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBasicCompositeField(Field field, Class<?> contextClass) {
        try {
            Class<?> componentType = ReflectionUtils.resolveComponentFieldType(field, contextClass);
            return ReflectionUtils.isBasicType(componentType);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Class<?> resolveFieldType(Field field, Class<?> contextClass) {
        try {
            Type resolvedType;
            Class rawType;
            Type genericType = field.getGenericType();
            if (genericType instanceof Class) {
                return (Class)genericType;
            }
            Map typeArguments = TypeUtils.getTypeArguments(contextClass, field.getDeclaringClass());
            if (!typeArguments.isEmpty() && (rawType = TypeUtils.getRawType((Type)(resolvedType = TypeUtils.unrollVariables((Map)typeArguments, (Type)genericType)), contextClass)) != null) {
                log.debug("Resolved generic type for field '{}' from '{}' to '{}'", new Object[]{field.getName(), genericType, rawType.getName()});
                return rawType;
            }
            Class rawType2 = TypeUtils.getRawType((Type)genericType, contextClass);
            if (rawType2 != null) {
                log.debug("Using raw type '{}' for field '{}'", (Object)rawType2.getName(), (Object)field.getName());
                return rawType2;
            }
        }
        catch (Exception e) {
            log.warn("Error resolving type for field '{}': {}", (Object)field.getName(), (Object)e.getMessage());
        }
        return field.getType();
    }

    public static Optional<String> getAnotationStringValue(AnnotatedElement annotatedElement, Class<?> annotationClass, Method valueAccesor) {
        try {
            String value;
            Object annotation = annotatedElement.getAnnotation(annotationClass);
            if (annotation != null && (value = (String)valueAccesor.invoke(annotation, new Object[0])) != null && !value.isBlank()) {
                return Optional.of(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Nullable
    public static Method tryGetMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Generated
    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

