/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb.resolvers;

import com.peluware.omnisearch.mongodb.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class CollectionNameResolver {
    private static final List<CollectionNameProvider> DEFAULT_PROVIDERS = new ArrayList<MorphiaEntityProvider>(List.of(new SpringDocumentProvider(), new QuarkusMongoEntityProvider(), new MorphiaEntityProvider()));
    private static final Map<Class<?>, String> COLLECTION_NAME_CACHE = new ConcurrentHashMap();

    public static String resolveCollectionName(Class<?> clazz) {
        return COLLECTION_NAME_CACHE.computeIfAbsent(clazz, c -> {
            for (CollectionNameProvider provider : DEFAULT_PROVIDERS) {
                Optional<String> result = provider.resolveCollectionName(clazz);
                if (!result.isPresent()) continue;
                return result.get();
            }
            return clazz.getSimpleName().toLowerCase();
        });
    }

    public static void addCollectionNameProvider(CollectionNameProvider provider) {
        if (provider != null) {
            DEFAULT_PROVIDERS.add(provider);
        }
    }

    public static void addCollectionNameProvider(int index, CollectionNameProvider provider) {
        if (provider != null) {
            DEFAULT_PROVIDERS.add(index, provider);
        }
    }

    @Generated
    private CollectionNameResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface CollectionNameProvider {
        public Optional<String> resolveCollectionName(Class<?> var1);
    }

    static class SpringDocumentProvider
    implements CollectionNameProvider {
        private static final boolean SPRING_AVAILABLE;
        private static final Class<?> DOCUMENT_ANNOTATION_CLASS;
        private static final Method VALUE_METHOD;
        private static final Method COLLECTION_METHOD;

        SpringDocumentProvider() {
        }

        @Override
        public Optional<String> resolveCollectionName(Class<?> clazz) {
            if (!SPRING_AVAILABLE) {
                return Optional.empty();
            }
            try {
                Object documentAnnotation = clazz.getAnnotation(DOCUMENT_ANNOTATION_CLASS);
                if (documentAnnotation != null) {
                    String collection = (String)COLLECTION_METHOD.invoke(documentAnnotation, new Object[0]);
                    if (collection != null && !collection.isBlank()) {
                        return Optional.of(collection);
                    }
                    String value = (String)VALUE_METHOD.invoke(documentAnnotation, new Object[0]);
                    if (value != null && !value.isBlank()) {
                        return Optional.of(value);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Optional.empty();
        }

        static {
            boolean springAvailable = false;
            Class<?> documentAnnotationClass = null;
            Method valueMethod = null;
            Method collectionMethod = null;
            try {
                documentAnnotationClass = Class.forName("org.springframework.data.mongodb.core.mapping.Document");
                springAvailable = true;
                valueMethod = ReflectionUtils.tryGetMethod(documentAnnotationClass, "value", new Class[0]);
                collectionMethod = ReflectionUtils.tryGetMethod(documentAnnotationClass, "collection", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            SPRING_AVAILABLE = springAvailable;
            DOCUMENT_ANNOTATION_CLASS = documentAnnotationClass;
            VALUE_METHOD = valueMethod;
            COLLECTION_METHOD = collectionMethod;
        }
    }

    static class QuarkusMongoEntityProvider
    implements CollectionNameProvider {
        private static final boolean QUARKUS_AVAILABLE;
        private static final Class<?> MONGO_ENTITY_ANNOTATION_CLASS;
        private static final Method COLLECTION_METHOD;

        QuarkusMongoEntityProvider() {
        }

        @Override
        public Optional<String> resolveCollectionName(Class<?> clazz) {
            if (!QUARKUS_AVAILABLE) {
                return Optional.empty();
            }
            return ReflectionUtils.getAnotationStringValue(clazz, MONGO_ENTITY_ANNOTATION_CLASS, COLLECTION_METHOD);
        }

        static {
            boolean quarkusAvailable = false;
            Class<?> mongoEntityAnnotationClass = null;
            Method collectionMethod = null;
            try {
                mongoEntityAnnotationClass = Class.forName("io.quarkus.mongodb.panache.common.MongoEntity");
                quarkusAvailable = true;
                collectionMethod = ReflectionUtils.tryGetMethod(mongoEntityAnnotationClass, "collection", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            QUARKUS_AVAILABLE = quarkusAvailable;
            MONGO_ENTITY_ANNOTATION_CLASS = mongoEntityAnnotationClass;
            COLLECTION_METHOD = collectionMethod;
        }
    }

    static class MorphiaEntityProvider
    implements CollectionNameProvider {
        private static final boolean MORPHIA_AVAILABLE;
        private static final Class<?> ENTITY_ANNOTATION_CLASS;
        private static final Method VALUE_METHOD;

        MorphiaEntityProvider() {
        }

        @Override
        public Optional<String> resolveCollectionName(Class<?> clazz) {
            if (!MORPHIA_AVAILABLE) {
                return Optional.empty();
            }
            return ReflectionUtils.getAnotationStringValue(clazz, ENTITY_ANNOTATION_CLASS, VALUE_METHOD);
        }

        static {
            boolean morphiaAvailable = false;
            Class<?> entityAnnotationClass = null;
            Method valueMethod = null;
            try {
                entityAnnotationClass = Class.forName("dev.morphia.annotations.Entity");
                morphiaAvailable = true;
                valueMethod = ReflectionUtils.tryGetMethod(entityAnnotationClass, "value", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                try {
                    entityAnnotationClass = Class.forName("org.mongodb.morphia.annotations.Entity");
                    morphiaAvailable = true;
                    valueMethod = ReflectionUtils.tryGetMethod(entityAnnotationClass, "value", new Class[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            MORPHIA_AVAILABLE = morphiaAvailable;
            ENTITY_ANNOTATION_CLASS = entityAnnotationClass;
            VALUE_METHOD = valueMethod;
        }
    }
}

