/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb.resolvers;

import com.peluware.omnisearch.mongodb.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bson.codecs.pojo.annotations.BsonProperty;

public final class PropertyNameResolver {
    private static final List<PropertyNameProvider> DEFAULT_PROVIDERS = new ArrayList<MorphiaPropertyProvider>(List.of(new BsonPropertyProvider(), new SpringFieldProvider(), new MorphiaPropertyProvider()));
    private static final Map<Field, String> PROPERTY_NAME_CACHE = new ConcurrentHashMap<Field, String>();

    public static String resolvePropertyName(Field field) {
        return PROPERTY_NAME_CACHE.computeIfAbsent(field, f -> {
            for (PropertyNameProvider provider : DEFAULT_PROVIDERS) {
                Optional<String> result = provider.resolvePropertyName((Field)f);
                if (!result.isPresent()) continue;
                return result.get();
            }
            return f.getName();
        });
    }

    public static void addPropertyNameProvider(PropertyNameProvider provider) {
        if (provider != null) {
            DEFAULT_PROVIDERS.add(provider);
        }
    }

    public static void addPropertyNameProvider(int index, PropertyNameProvider provider) {
        if (provider != null) {
            DEFAULT_PROVIDERS.add(index, provider);
        }
    }

    @Generated
    private PropertyNameResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface PropertyNameProvider {
        public Optional<String> resolvePropertyName(Field var1);
    }

    static class BsonPropertyProvider
    implements PropertyNameProvider {
        BsonPropertyProvider() {
        }

        @Override
        public Optional<String> resolvePropertyName(Field field) {
            BsonProperty annotation;
            if (field.isAnnotationPresent(BsonProperty.class) && (annotation = field.getAnnotation(BsonProperty.class)).value() != null && !annotation.value().isBlank()) {
                return Optional.of(annotation.value());
            }
            return Optional.empty();
        }
    }

    static class SpringFieldProvider
    implements PropertyNameProvider {
        private static final boolean SPRING_AVAILABLE;
        private static final Class<?> FIELD_ANNOTATION_CLASS;
        private static final Method VALUE_METHOD;

        SpringFieldProvider() {
        }

        @Override
        public Optional<String> resolvePropertyName(Field field) {
            if (!SPRING_AVAILABLE) {
                return Optional.empty();
            }
            return ReflectionUtils.getAnotationStringValue(field, FIELD_ANNOTATION_CLASS, VALUE_METHOD);
        }

        static {
            boolean springAvailable = false;
            Class<?> fieldAnnotationClass = null;
            Method method = null;
            try {
                fieldAnnotationClass = Class.forName("org.springframework.data.mongodb.core.mapping.Field");
                springAvailable = true;
                method = ReflectionUtils.tryGetMethod(fieldAnnotationClass, "value", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            SPRING_AVAILABLE = springAvailable;
            FIELD_ANNOTATION_CLASS = fieldAnnotationClass;
            VALUE_METHOD = method;
        }
    }

    static class MorphiaPropertyProvider
    implements PropertyNameProvider {
        private static final boolean MORPHIA_AVAILABLE;
        private static final Class<?> PROPERTY_ANNOTATION_CLASS;
        private static final Method VALUE_METHOD;

        MorphiaPropertyProvider() {
        }

        @Override
        public Optional<String> resolvePropertyName(Field field) {
            if (!MORPHIA_AVAILABLE) {
                return Optional.empty();
            }
            return ReflectionUtils.getAnotationStringValue(field, PROPERTY_ANNOTATION_CLASS, VALUE_METHOD);
        }

        static {
            boolean morphiaAvailable = false;
            Class<?> propertyAnnotationClass = null;
            Method method = null;
            try {
                propertyAnnotationClass = Class.forName("dev.morphia.annotations.Property");
                morphiaAvailable = true;
                method = ReflectionUtils.tryGetMethod(propertyAnnotationClass, "value", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                try {
                    propertyAnnotationClass = Class.forName("org.mongodb.morphia.annotations.Property");
                    morphiaAvailable = true;
                    method = ReflectionUtils.tryGetMethod(propertyAnnotationClass, "value", new Class[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            MORPHIA_AVAILABLE = morphiaAvailable;
            PROPERTY_ANNOTATION_CLASS = propertyAnnotationClass;
            VALUE_METHOD = method;
        }
    }
}

