/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.omnisearch.mongodb.rsql;

import com.mongodb.client.model.Filters;
import com.peluware.omnisearch.core.rsql.RsqlArgumentParser;
import com.peluware.omnisearch.mongodb.ReflectionUtils;
import com.peluware.omnisearch.mongodb.resolvers.PropertyNameResolver;
import com.peluware.omnisearch.mongodb.rsql.RsqlMongoBuilderOptions;
import com.peluware.omnisearch.mongodb.rsql.RsqlMongoComparisionFilterBuilder;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.LogicalOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoFilterVisitor<T>
implements RSQLVisitor<Bson, Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoFilterVisitor.class);
    private final Class<T> documentClass;
    private final RsqlMongoBuilderOptions builderOptions;
    private final Map<String, FieldPath> fieldPathCache = new HashMap<String, FieldPath>();

    public Bson visit(AndNode node, Void param) {
        log.debug("Creating Bson for AndNode: {}", (Object)node);
        return this.visitLogicalNode((LogicalNode)node);
    }

    public Bson visit(OrNode node, Void param) {
        log.debug("Creating Bson for OrNode: {}", (Object)node);
        return this.visitLogicalNode((LogicalNode)node);
    }

    private Bson visitLogicalNode(LogicalNode node) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return Filters.where((String)"false");
        }
        ArrayList<Bson> filters = new ArrayList<Bson>();
        for (Node childNode : children) {
            filters.add((Bson)childNode.accept((RSQLVisitor)this, null));
        }
        return switch (node.getOperator()) {
            default -> throw new MatchException(null, null);
            case LogicalOperator.OR -> Filters.or(filters);
            case LogicalOperator.AND -> Filters.and(filters);
        };
    }

    public Bson visit(ComparisonNode node, Void param) {
        log.debug("Creating Predicate for ComparisonNode: {}", (Object)node);
        RsqlArgumentParser argumentParser = this.builderOptions.getArgumentParser();
        FieldPath fieldPath = this.findFieldType(node.getSelector(), this.documentClass);
        List castedArguments = argumentParser.parse(node.getArguments(), fieldPath.type);
        RsqlMongoComparisionFilterBuilder comparisionFilterBuilder = this.builderOptions.getComparisionFilterBuilder();
        return comparisionFilterBuilder.buildComparisionFilter(fieldPath.path, fieldPath.type, node.getOperator(), castedArguments);
    }

    protected FieldPath findFieldType(String originalPath, Class<?> clazz) {
        String cacheKey = clazz.getName() + "#" + originalPath;
        FieldPath cached = this.fieldPathCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        String[] graph = originalPath.split("\\.");
        Class<?> currentClass = clazz;
        ArrayList<String> paths = new ArrayList<String>();
        for (String attribute : graph) {
            Field field = FieldUtils.getField(currentClass, (String)attribute, (boolean)true);
            if (field == null) {
                log.trace("Field '{}' not found in class hierarchy of '{}'", (Object)attribute, (Object)currentClass.getName());
                throw new IllegalArgumentException(String.format("Field '%s' not found in class hierarchy of '%s'", attribute, currentClass.getName()));
            }
            Class<?> resolvedClass = ReflectionUtils.resolveFieldType(field, currentClass);
            currentClass = resolvedClass.isArray() || Collection.class.isAssignableFrom(resolvedClass) ? ReflectionUtils.resolveComponentFieldType(field, currentClass) : resolvedClass;
            paths.add(PropertyNameResolver.resolvePropertyName(field));
            log.trace("Resolved field '{}' to path '{}' with type '{}'", new Object[]{attribute, paths.getLast(), currentClass.getName()});
        }
        String resolvedPath = String.join((CharSequence)".", paths);
        FieldPath result = new FieldPath(resolvedPath, currentClass);
        this.fieldPathCache.put(cacheKey, result);
        log.debug("Resolved full path '{}' to '{}' with final type '{}'", new Object[]{originalPath, resolvedPath, currentClass.getName()});
        return result;
    }

    public void clearCache() {
        this.fieldPathCache.clear();
        log.debug("Field path cache cleared");
    }

    @Generated
    public MongoFilterVisitor(Class<T> documentClass, RsqlMongoBuilderOptions builderOptions) {
        this.documentClass = documentClass;
        this.builderOptions = builderOptions;
    }

    protected record FieldPath(String path, Class<?> type) {
    }
}

