/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core;

import com.peluware.springframework.crud.core.CrudOperation;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public interface AuthorizedCrud {
    public static final AuthorizationDecision GRANTED = new AuthorizationDecision(true);
    public static final AuthorizationDecision DENIED = new AuthorizationDecision(false);

    public AuthorizationManager<CrudOperation> getAuthorizationManager();

    public static void verifyAccess(AuthorizedCrud authorizedCrud, CrudOperation operation) {
        AuthorizationManager<CrudOperation> authorizationManager = authorizedCrud.getAuthorizationManager();
        SecurityContext context = SecurityContextHolder.getContext();
        authorizationManager.verify(() -> ((SecurityContext)context).getAuthentication(), (Object)operation);
    }
}

