/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core;

import com.peluware.springframework.crud.core.Crud;
import com.peluware.springframework.crud.core.CrudOperation;
import com.peluware.springframework.crud.core.exceptions.NotFoundEntityException;
import com.peluware.springframework.crud.core.hooks.ReadHooks;
import com.peluware.springframework.crud.core.utils.StringUtils;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Persistable;
import org.springframework.validation.annotation.Validated;

@Validated
public non-sealed interface ReadService<E extends Persistable<ID>, ID>
extends Crud {
    default public ReadHooks<E, ID> getHooks() {
        return ReadHooks.getDefault();
    }

    default public Page<E> page(String search, Pageable pageable, Node query) {
        Crud.preProccess(this, CrudOperation.PAGE);
        String normalized = StringUtils.normalize(search);
        Page<E> page = this.resolvePage(normalized, pageable, query);
        ReadHooks<E, ID> hooks = this.getHooks();
        hooks.onPage(page);
        return page;
    }

    default public E find(ID id) {
        Crud.preProccess(this, CrudOperation.FIND);
        E model = this.internalFind(id);
        ReadHooks<E, ID> hooks = this.getHooks();
        hooks.onFind(model);
        return model;
    }

    default public List<E> find(List<ID> ids) {
        Crud.preProccess(this, CrudOperation.FIND);
        List<E> list = this.internalFind(ids);
        ReadHooks<E, ID> hooks = this.getHooks();
        hooks.onFind(list, ids);
        return list;
    }

    default public long count(String search, Node query) {
        Crud.preProccess(this, CrudOperation.COUNT);
        long count = this.resolveCount(search, query);
        ReadHooks<E, ID> hooks = this.getHooks();
        hooks.onCount(count);
        return count;
    }

    default public boolean exists(ID id) {
        Crud.preProccess(this, CrudOperation.EXISTS);
        boolean exists = this.internalExists(id);
        ReadHooks<E, ID> hooks = this.getHooks();
        hooks.onExists(exists, id);
        return exists;
    }

    public Page<E> internalPage(Pageable var1);

    public Page<E> internalSearch(String var1, Pageable var2);

    public Page<E> internalSearch(String var1, Pageable var2, Node var3);

    public E internalFind(ID var1) throws NotFoundEntityException;

    public List<E> internalFind(List<ID> var1);

    public long internalCount();

    public long internalCount(String var1);

    public long internalCount(String var1, Node var2);

    public boolean internalExists(ID var1);

    private Page<E> resolvePage(String search, Pageable pageable, Node query) {
        if (query == null) {
            if (search == null || search.isBlank()) {
                return this.internalPage(pageable);
            }
            return this.internalSearch(search, pageable);
        }
        return this.internalSearch(search, pageable, query);
    }

    private long resolveCount(String search, Node query) {
        if (query == null) {
            if (search == null || search.isBlank()) {
                return this.internalCount();
            }
            return this.internalCount(search);
        }
        return this.internalCount(search, query);
    }
}

