/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core;

import com.peluware.omnisearch.core.OmniSearch;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.OmniSearchOptions;
import com.peluware.springframework.crud.core.OmniSearchOptionsFactory;
import com.peluware.springframework.crud.core.ReadService;
import com.peluware.springframework.crud.core.exceptions.NotFoundEntityException;
import com.peluware.springframework.crud.core.providers.EntityClassProvider;
import com.peluware.springframework.crud.core.providers.RepositoryProvider;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.support.PageableExecutionUtils;

public interface StandardReadService<E extends Persistable<ID>, ID, R extends ListCrudRepository<E, ID> & PagingAndSortingRepository<E, ID>>
extends ReadService<E, ID>,
EntityClassProvider<E>,
RepositoryProvider<R> {
    @Override
    default public Page<E> internalPage(Pageable pageable) {
        return ((PagingAndSortingRepository)((ListCrudRepository)this.getRepository())).findAll(pageable);
    }

    @Override
    default public E internalFind(ID id) {
        return (E)((Persistable)((ListCrudRepository)this.getRepository()).findById(id).orElseThrow(() -> new NotFoundEntityException(this.getEntityClass(), id)));
    }

    @Override
    default public List<E> internalFind(List<ID> ids) {
        return ((ListCrudRepository)this.getRepository()).findAllById(ids);
    }

    @Override
    default public long internalCount() {
        return ((ListCrudRepository)this.getRepository()).count();
    }

    @Override
    default public boolean internalExists(ID id) {
        return ((ListCrudRepository)this.getRepository()).existsById(id);
    }

    @Override
    default public Page<E> internalSearch(String search, Pageable pageable) {
        return this.internalSearch(search, pageable, null);
    }

    @Override
    default public Page<E> internalSearch(String search, Pageable pageable, Node query) {
        OmniSearchOptions options = this.toSearchOptions(search, pageable, query);
        Class entityClass = this.getEntityClass();
        OmniSearch omniSearch = this.getOmniSearch();
        return PageableExecutionUtils.getPage((List)omniSearch.search(entityClass, options), (Pageable)pageable, () -> omniSearch.count(entityClass, (OmniSearchBaseOptions)options));
    }

    @Override
    default public long internalCount(String search) {
        return this.internalCount(search, null);
    }

    @Override
    default public long internalCount(String search, Node query) {
        OmniSearchBaseOptions options = this.toBaseSearchOptions(search, query);
        OmniSearch omniSearch = this.getOmniSearch();
        return omniSearch.count(this.getEntityClass(), options);
    }

    public OmniSearch getOmniSearch();

    default public OmniSearchOptions toSearchOptions(String search, Pageable pageable, Node query) {
        return OmniSearchOptionsFactory.create(search, pageable, query);
    }

    default public OmniSearchBaseOptions toBaseSearchOptions(String search, Node query) {
        return OmniSearchOptionsFactory.create(search, query);
    }
}

