/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core;

import com.peluware.springframework.crud.core.Crud;
import com.peluware.springframework.crud.core.CrudOperation;
import com.peluware.springframework.crud.core.exceptions.NotFoundEntityException;
import com.peluware.springframework.crud.core.hooks.WriteHooks;
import com.peluware.springframework.crud.core.providers.EntityClassProvider;
import com.peluware.springframework.crud.core.providers.TransactionOperationsProvider;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.springframework.data.domain.Persistable;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.validation.annotation.Validated;

@Validated
public non-sealed interface WriteService<E extends Persistable<ID>, D, ID>
extends Crud,
EntityClassProvider<E>,
TransactionOperationsProvider {
    default public WriteHooks<E, D, ID> getHooks() {
        return WriteHooks.getDefault();
    }

    default public E create(@Valid @NotNull D dto) {
        Crud.preProccess(this, CrudOperation.CREATE);
        E entity = this.newEntity();
        WriteHooks<E, D, ID> hooks = this.getHooks();
        TransactionOperations transactionOperations = this.getTransactionOperations();
        return (E)((Persistable)transactionOperations.execute(status -> {
            try {
                this.mapModel(dto, entity);
                hooks.onBeforeCreate(dto, entity);
                this.internalCreate(entity);
                hooks.onAfterCreate(dto, entity);
                return entity;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
        }));
    }

    default public E update(@NotNull ID id, @Valid @NotNull D dto) throws NotFoundEntityException {
        Crud.preProccess(this, CrudOperation.UPDATE);
        E entity = this.internalFind(id);
        WriteHooks<E, D, ID> hooks = this.getHooks();
        TransactionOperations transactionOperations = this.getTransactionOperations();
        return (E)((Persistable)transactionOperations.execute(status -> {
            try {
                this.mapModel(dto, entity);
                hooks.onBeforeUpdate(dto, entity);
                this.internalUpdate(entity);
                hooks.onAfterUpdate(dto, entity);
                return entity;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
        }));
    }

    default public void delete(@NotNull ID id) throws NotFoundEntityException {
        Crud.preProccess(this, CrudOperation.DELETE);
        E entity = this.internalFind(id);
        WriteHooks<E, D, ID> hooks = this.getHooks();
        hooks.onBeforeDelete(entity);
        this.internalDelete(entity);
        hooks.onAfterDelete(entity);
    }

    default public E newEntity() {
        return (E)((Persistable)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public E internalFind(ID var1) throws NotFoundEntityException;

    public void mapModel(D var1, E var2);

    public void internalCreate(E var1);

    public void internalUpdate(E var1);

    public void internalDelete(E var1);
}

