/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.autoconfigurations;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.Node;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;

@AutoConfiguration
public class SpringDataCrudAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringDataCrudAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Converter<String, Node> rsqlQueryConverter() {
        RSQLParser parser = new RSQLParser();
        return source -> {
            if (source.isBlank()) {
                return null;
            }
            try {
                return parser.parse(source);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid RSQL query: " + source, e);
            }
        };
    }
}

