/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.autoconfigurations;

import cz.jirutka.rsql.parser.ast.Node;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringDataWebProperties.class})
@ConditionalOnClass(value={SpringDocConfiguration.class})
@ConditionalOnWebApplication
public class SpringDocDataCrudAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringDocDataCrudAutoConfiguration.class);
    private final SpringDataWebProperties springDataWebProperties;

    @Bean
    public OperationCustomizer pageableParameterCustomizer() {
        log.debug("Configuring pageable parameters for Spring Data CRUD operations");
        SpringDataWebProperties.Pageable pageable = this.springDataWebProperties.getPageable();
        SpringDataWebProperties.Sort sort = this.springDataWebProperties.getSort();
        Parameter pageParameter = new QueryParameter().name(pageable.getPageParameter()).schema((Schema)new IntegerSchema()._default((Number)0)).description("Page number to retrieve (0-based index)").required(Boolean.valueOf(false));
        Parameter sizeParameter = new QueryParameter().name(pageable.getSizeParameter()).schema(new IntegerSchema()._default((Number)pageable.getDefaultPageSize()).minimum(BigDecimal.valueOf(1L)).maximum(BigDecimal.valueOf(pageable.getMaxPageSize()))).description("Number of items per page").required(Boolean.valueOf(false));
        Parameter sortParameter = new QueryParameter().name(sort.getSortParameter()).schema((Schema)new ArraySchema().items((Schema)new StringSchema())).description("Sorting criteria in the format: property,(asc|desc). Multiple properties can be specified using commas.").required(Boolean.valueOf(false));
        return (operation, handlerMethod) -> {
            Optional<String> pageableParameterName = SpringDocDataCrudAutoConfiguration.resolvePageableParameterName(handlerMethod);
            if (pageableParameterName.isEmpty()) {
                return operation;
            }
            ArrayList<Parameter> parameters = operation.getParameters();
            if (parameters == null) {
                parameters = new ArrayList<Parameter>();
                operation.setParameters(parameters);
            }
            parameters.removeIf(param -> ((String)pageableParameterName.get()).equals(param.getName()));
            parameters.add(pageParameter);
            parameters.add(sizeParameter);
            parameters.add(sortParameter);
            return operation;
        };
    }

    @Bean
    public OperationCustomizer nodeParameterCustomizer() {
        log.debug("Configuring RSQL query parameter for Spring Data CRUD operations");
        return (operation, handlerMethod) -> {
            Optional<ParameterName> requestParamName = SpringDocDataCrudAutoConfiguration.resolveNodeParameterName(handlerMethod);
            if (requestParamName.isEmpty()) {
                return operation;
            }
            ParameterName parameterName = requestParamName.get();
            ArrayList<Parameter> parameters = operation.getParameters();
            if (parameters == null) {
                parameters = new ArrayList<Parameter>();
                operation.setParameters(parameters);
            }
            parameters.removeIf(param -> parameterName.name.equals(param.getName()));
            parameters.add(new QueryParameter().name(parameterName.name).schema((Schema)new StringSchema()).description("RSQL query string to filter results").required(Boolean.valueOf(parameterName.required)));
            return operation;
        };
    }

    private static Optional<ParameterName> resolveNodeParameterName(HandlerMethod handlerMethod) {
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            parameter.initParameterNameDiscovery((ParameterNameDiscoverer)new SpringDocParameterNameDiscoverer());
            if (!Node.class.isAssignableFrom(parameter.getParameterType())) continue;
            RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
            if (requestParam != null && !requestParam.value().isEmpty()) {
                return Optional.of(new ParameterName(requestParam.value(), requestParam.required()));
            }
            String parameterName = parameter.getParameterName();
            if (parameterName == null) continue;
            return Optional.of(new ParameterName(parameterName, true));
        }
        return Optional.empty();
    }

    private static Optional<String> resolvePageableParameterName(HandlerMethod handlerMethod) {
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            parameter.initParameterNameDiscovery((ParameterNameDiscoverer)new SpringDocParameterNameDiscoverer());
            if (!Pageable.class.isAssignableFrom(parameter.getParameterType())) continue;
            RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
            if (requestParam != null && !requestParam.value().isEmpty()) {
                return Optional.of(requestParam.value());
            }
            String parameterName = parameter.getParameterName();
            return Optional.of(Objects.requireNonNull(parameterName));
        }
        return Optional.empty();
    }

    @Generated
    public SpringDocDataCrudAutoConfiguration(SpringDataWebProperties springDataWebProperties) {
        this.springDataWebProperties = springDataWebProperties;
    }

    private record ParameterName(String name, boolean required) {
    }
}

