/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.utils;

import com.peluware.springframework.crud.core.utils.StringUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public final class ResponseEntityUtils {
    public static ResponseEntity<ByteArrayResource> resource(byte[] content, String filename, MediaType mediaType, boolean inline) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).contentType(mediaType).headers(ResponseEntityUtils.getHeadersForFile(filename, inline))).body((Object)new ByteArrayResource(content));
    }

    public static ResponseEntity<ByteArrayResource> resource(byte[] content, String filename, MediaType mediaType) {
        return ResponseEntityUtils.resource(content, filename, mediaType, false);
    }

    private static HttpHeaders getHeadersForFile(String filename, boolean inline) {
        String safeFilename = StringUtils.toASCII(filename);
        String encodedFilename = URLEncoder.encode(filename, StandardCharsets.UTF_8).replace("+", "%20");
        String headerValue = (inline ? "inline" : "attachment") + "; filename=\"" + safeFilename + "\"; filename*=UTF-8''" + encodedFilename;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Disposition", headerValue);
        headers.setAccessControlExposeHeaders(List.of("Content-Disposition"));
        return headers;
    }

    @Generated
    private ResponseEntityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

