/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.utils;

import java.text.Normalizer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    @NotNull
    public static String toASCII(@NotNull String string) {
        try {
            String normalizedString = Normalizer.normalize(string, Normalizer.Form.NFD);
            return normalizedString.replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{ASCII}]", "");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error normalizando la cadena", e);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isBlank(String string) {
        return string == null || string.isBlank();
    }

    public static String normalize(String search) {
        return StringUtils.isBlank(search) ? null : search.trim();
    }

    @Generated
    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

