/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.web.controllers;

import com.peluware.springframework.crud.core.ReadService;
import com.peluware.springframework.crud.core.utils.ResponseEntityUtils;
import com.peluware.springframework.crud.core.web.export.Exporter;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.List;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public interface ExportController<ID, O> {
    public ReadService<?, ID> getService();

    public Exporter<O> getExporter();

    public O getExportOptions(MultiValueMap<String, String> var1);

    @GetMapping(value={"/export"})
    default public ResponseEntity<ByteArrayResource> exportPage(@RequestParam(required=false) String search, @RequestParam(required=false) Node query, @RequestParam(required=false) MultiValueMap<String, String> params, Pageable pageable) {
        O options = this.getExportOptions(params);
        Page<?> entities = this.getService().page(search, pageable, query);
        Exporter.ExportResource exported = this.getExporter().export((Iterable<?>)entities, options);
        return ResponseEntityUtils.resource(exported.getByteArray(), exported.getFilename(), exported.getMediaType());
    }

    @GetMapping(value={"/export/{id}"})
    default public ResponseEntity<ByteArrayResource> exportFind(@PathVariable ID id, @RequestParam(required=false) MultiValueMap<String, String> params) {
        O options = this.getExportOptions(params);
        Object entity = this.getService().find(id);
        Exporter.ExportResource exported = this.getExporter().export(List.of(entity), options);
        return ResponseEntityUtils.resource(exported.getByteArray(), exported.getFilename(), exported.getMediaType());
    }
}

