/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.web.controllers;

import com.peluware.springframework.crud.core.ReadService;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Persistable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public interface ReadController<M extends Persistable<ID>, ID> {
    public ReadService<M, ID> getService();

    @GetMapping
    default public ResponseEntity<Page<M>> page(@RequestParam(required=false) String search, @RequestParam(required=false) Node query, Pageable pageable) {
        return ResponseEntity.ok(this.getService().page(search, pageable, query));
    }

    @GetMapping(value={"/{id}"})
    default public ResponseEntity<M> find(@PathVariable ID id) {
        return ResponseEntity.ok(this.getService().find(id));
    }

    @GetMapping(value={"/ids"})
    default public ResponseEntity<List<M>> find(@RequestParam List<ID> ids) {
        return ResponseEntity.ok(this.getService().find(ids));
    }

    @GetMapping(value={"/count"})
    default public ResponseEntity<Long> count(@RequestParam(required=false) String search, @RequestParam(required=false) Node query) {
        return ResponseEntity.ok((Object)this.getService().count(search, query));
    }

    @GetMapping(value={"/exists"})
    default public ResponseEntity<Boolean> exists(@RequestParam ID id) {
        return ResponseEntity.ok((Object)this.getService().exists(id));
    }
}

