/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.core.web.controllers;

import com.peluware.springframework.crud.core.WriteService;
import org.springframework.data.domain.Persistable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface WriteController<M extends Persistable<ID>, D, ID> {
    public WriteService<M, D, ID> getService();

    @PostMapping
    default public ResponseEntity<M> create(@RequestBody D dto) {
        return ResponseEntity.ok(this.getService().create(dto));
    }

    @PutMapping(value={"/{id}"})
    default public ResponseEntity<M> update(@PathVariable ID id, @RequestBody D dto) {
        return ResponseEntity.ok(this.getService().update(id, dto));
    }

    @DeleteMapping(value={"/{id}"})
    default public ResponseEntity<String> delete(@PathVariable ID id) {
        this.getService().delete(id);
        return ResponseEntity.ok((Object)this.deletedMessage(id));
    }

    default public String deletedMessage(ID id) {
        return "Deleted " + String.valueOf(id);
    }
}

