/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.jpa;

import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.OmniSearchOptions;
import com.peluware.omnisearch.jpa.JpaOmniSearch;
import com.peluware.springframework.crud.core.CrudOperation;
import com.peluware.springframework.crud.core.OmniSearchOptionsFactory;
import com.peluware.springframework.crud.core.ReadService;
import com.peluware.springframework.crud.core.exceptions.NotFoundEntityException;
import com.peluware.springframework.crud.core.providers.EntityClassProvider;
import com.peluware.springframework.crud.core.providers.RepositoryProvider;
import com.peluware.springframework.crud.jpa.providers.EntityManagerProvider;
import cz.jirutka.rsql.parser.ast.Node;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

public interface JpaSpecificationReadService<E extends Persistable<ID>, ID, R extends JpaSpecificationExecutor<E>>
extends ReadService<E, ID>,
RepositoryProvider<R>,
EntityManagerProvider,
EntityClassProvider<E> {
    default public Page<E> internalPage(Pageable pageable) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> null;
        return ((JpaSpecificationExecutor)this.getRepository()).findAll(this.combineSpecification(spec, CrudOperation.PAGE), pageable);
    }

    default public Page<E> internalSearch(String search, Pageable pageable) {
        return this.internalSearch(search, pageable, null);
    }

    default public Page<E> internalSearch(String search, Pageable pageable, Node query) {
        OmniSearchOptions options = this.toSearchOptions(search, pageable, query);
        Specification & Serializable spec = (Specification & Serializable)(root, q, cb) -> this.getOmniSearch().buildPredicate(root, cb, (OmniSearchBaseOptions)options);
        return ((JpaSpecificationExecutor)this.getRepository()).findAll(this.combineSpecification(spec, CrudOperation.PAGE), pageable);
    }

    default public E internalFind(ID id) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(this.getIdFieldName()), id);
        return (E)((Persistable)((JpaSpecificationExecutor)this.getRepository()).findOne(this.combineSpecification(spec, CrudOperation.FIND)).orElseThrow(() -> new NotFoundEntityException(this.getEntityClass(), id)));
    }

    default public List<E> internalFind(List<ID> ids) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> root.get(this.getIdFieldName()).in((Collection)ids);
        return ((JpaSpecificationExecutor)this.getRepository()).findAll(this.combineSpecification(spec, CrudOperation.FIND));
    }

    default public long internalCount() {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> null;
        return ((JpaSpecificationExecutor)this.getRepository()).count(this.combineSpecification(spec, CrudOperation.COUNT));
    }

    default public long internalCount(String search) {
        return this.internalCount(search, null);
    }

    default public long internalCount(String search, Node query) {
        OmniSearchBaseOptions options = this.toBaseSearchOptions(search, query);
        Specification & Serializable spec = (Specification & Serializable)(root, q, cb) -> this.getOmniSearch().buildPredicate(root, cb, options);
        return ((JpaSpecificationExecutor)this.getRepository()).count(this.combineSpecification(spec, CrudOperation.COUNT));
    }

    default public boolean internalExists(ID id) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(this.getIdFieldName()), id);
        return ((JpaSpecificationExecutor)this.getRepository()).exists(this.combineSpecification(spec, CrudOperation.EXISTS));
    }

    default public String getIdFieldName() {
        return "id";
    }

    default public Specification<E> combineSpecification(Specification<E> spec, CrudOperation operation) {
        return spec;
    }

    default public JpaOmniSearch getOmniSearch() {
        return new JpaOmniSearch(this.getEntityManager());
    }

    default public OmniSearchOptions toSearchOptions(String search, Pageable pageable, Node query) {
        return OmniSearchOptionsFactory.create((String)search, (Pageable)pageable, (Node)query);
    }

    default public OmniSearchBaseOptions toBaseSearchOptions(String search, Node query) {
        return OmniSearchOptionsFactory.create((String)search, (Node)query);
    }
}

