/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.crud.mongo;

import com.peluware.domain.Pagination;
import com.peluware.domain.Sort;
import com.peluware.omnisearch.core.OmniSearchBaseOptions;
import com.peluware.omnisearch.core.OmniSearchOptions;
import com.peluware.omnisearch.mongodb.MongoOmniSearch;
import com.peluware.omnisearch.mongodb.rsql.RsqlMongoBuilderOptions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

public class MongoTemplateOmniSearch
extends MongoOmniSearch {
    private final MongoTemplate mongoTemplate;

    public MongoTemplateOmniSearch(MongoTemplate mongoTemplate, RsqlMongoBuilderOptions rsqlBuilderOptions) {
        super(null, rsqlBuilderOptions);
        this.mongoTemplate = mongoTemplate;
    }

    public MongoTemplateOmniSearch(MongoTemplate mongoTemplate) {
        super(null);
        this.mongoTemplate = mongoTemplate;
    }

    public <E> List<E> search(Class<E> entityClass, OmniSearchOptions options) {
        Objects.requireNonNull(entityClass, "Entity class cannot be null");
        Objects.requireNonNull(options, "Options cannot be null");
        Query query = this.buildQuery(entityClass, options);
        return this.mongoTemplate.find(query, entityClass);
    }

    public <E> long count(Class<E> entityClass, OmniSearchBaseOptions options) {
        Objects.requireNonNull(entityClass, "Entity class cannot be null");
        Objects.requireNonNull(options, "Options cannot be null");
        Query query = this.buildBaseQuery(entityClass, options);
        return this.mongoTemplate.count(query, entityClass);
    }

    public <E> Query buildQuery(Class<E> entityClass, OmniSearchOptions options) {
        Pagination pagination;
        Query query = this.buildBaseQuery(entityClass, (OmniSearchBaseOptions)options);
        Sort sort = options.getSort();
        if (sort.isSorted()) {
            query.with(MongoTemplateOmniSearch.buildSort(sort));
        }
        if ((pagination = options.getPagination()).isPaginated()) {
            query.limit(pagination.size().intValue()).skip((long)pagination.offset());
        }
        return query;
    }

    @NotNull
    private Query buildBaseQuery(Class<?> entityClass, OmniSearchBaseOptions options) {
        final Bson filter = this.buildFilter(entityClass, options);
        return new Query(){

            @NotNull
            public Document getQueryObject() {
                BsonDocument bsonDoc = filter.toBsonDocument(BsonDocument.class, MongoTemplateOmniSearch.this.mongoTemplate.getConverter().getCodecRegistry());
                return new Document((Map)bsonDoc);
            }
        };
    }

    private static org.springframework.data.domain.Sort buildSort(Sort sort) {
        return org.springframework.data.domain.Sort.by(sort.orders().stream().map(o -> o.ascending() ? Sort.Order.asc((String)o.property()) : Sort.Order.desc((String)o.property())).toList());
    }
}

