/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.web.problemdetails;

import com.peluware.springframework.web.problemdetails.ProblemDetailsException;
import com.peluware.springframework.web.problemdetails.ResponseEntityExceptionHandlerResolver;
import com.peluware.springframework.web.problemdetails.UncaughtProblemDetailCallback;
import com.peluware.springframework.web.problemdetails.ValidationException;
import com.peluware.springframework.web.problemdetails.configuration.ProblemDetailsProperties;
import com.peluware.springframework.web.problemdetails.configuration.ProblemDetailsPropertiesAware;
import com.peluware.springframework.web.problemdetails.configuration.ResponseEntityExceptionHandlerResolverAware;
import com.peluware.springframework.web.problemdetails.schemas.FieldMessage;
import com.peluware.springframework.web.problemdetails.schemas.ValidationErrors;
import com.peluware.springframework.web.problemdetails.utils.ExceptionUtils;
import jakarta.validation.ConstraintViolationException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class DefaultProblemDetailsExceptionHandler
extends ResponseEntityExceptionHandler
implements ProblemDetailsPropertiesAware,
ResponseEntityExceptionHandlerResolverAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProblemDetailsExceptionHandler.class);
    private boolean allErrors;
    private boolean sendStackTrace;
    private ResponseEntityExceptionHandlerResolver resolver;
    private UncaughtProblemDetailCallback uncaughtProblemDetailCallback = UncaughtProblemDetailCallback.none();

    @Override
    public void setProblemDetailsProperties(ProblemDetailsProperties properties) {
        log.debug("Setting error properties: {}", (Object)properties);
        this.allErrors = properties.isAllErrors();
        this.sendStackTrace = properties.isSendStackTrace();
    }

    @Override
    public void setResponseEntityExceptionHandlerResolver(ResponseEntityExceptionHandlerResolver resolver) {
        log.debug("Setting response entity exception handler resolver: {}", (Object)resolver);
        this.resolver = resolver;
    }

    public void setMessageSource(@NotNull MessageSource messageSource) {
        log.debug("Setting message source: {}", (Object)messageSource);
        log.debug("Message source class: {}", (Object)messageSource.getClass());
        super.setMessageSource(messageSource);
    }

    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<Object> handleDefaultException(Exception ex, WebRequest request) {
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        ProblemDetail body = this.allErrors ? this.createProblemDetail(ex, (HttpStatusCode)statusCode, ex.getMessage(), "problemDetail.java.lang.Exception.message", new Object[]{ex.getMessage()}, request) : this.createProblemDetail(ex, (HttpStatusCode)statusCode, "Internal Server Error", "problemDetail.java.lang.Exception", null, request);
        this.uncaughtProblemDetailCallback.call(ex, body);
        return this.createResponseEntity(ex, new HttpHeaders(), (HttpStatusCode)statusCode, request, body);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public final ResponseEntity<Object> handleRuntimeException(RuntimeException ex, WebRequest request) throws NoSuchMethodException {
        Throwable cause;
        if (RuntimeException.class.equals(ex.getClass()) && (cause = ex.getCause()) != null) {
            if (RuntimeException.class.equals(cause.getClass())) {
                return this.handleRuntimeException((RuntimeException)cause, request);
            }
            if (cause instanceof Exception) {
                Exception exception = (Exception)cause;
                return this.resolver.handleException(exception, request);
            }
        }
        return this.handleDefaultException(ex, request);
    }

    @ExceptionHandler(value={ProblemDetailsException.class})
    public final ResponseEntity<Object> handleProblemDetailsException(ProblemDetailsException ex, WebRequest ignored) {
        ProblemDetail problem = ex.getBody();
        this.precessException(ex, problem);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)problem.getStatus()).headers(ex.getHeaders())).body((Object)problem);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Object> handleConstraintViolationException(ConstraintViolationException ex, WebRequest request) {
        String defaultDetail = "One or more fields are invalid.";
        ProblemDetail body = this.createProblemDetail((Exception)ex, (HttpStatusCode)HttpStatus.BAD_REQUEST, defaultDetail, null, null, request);
        DefaultProblemDetailsExceptionHandler.addValidationErrors(body, ex.getConstraintViolations(), violation -> {
            log.debug("Property path: {}, Class bean {}", (Object)violation.getPropertyPath(), (Object)violation.getRootBeanClass());
            violation.getPropertyPath();
            String path = violation.getPropertyPath().toString();
            return new FieldMessage(path, violation.getMessage());
        });
        return this.createResponseEntity((Exception)ex, new HttpHeaders(), (HttpStatusCode)HttpStatus.BAD_REQUEST, request, body);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Object> handleValidationException(ValidationException ex, WebRequest request) {
        HttpStatus statusCode = HttpStatus.BAD_REQUEST;
        ProblemDetail body = this.createProblemDetail(ex, (HttpStatusCode)statusCode, ex.getMessage(), null, null, request);
        ValidationErrors validationErrors = ex.getValidationErrors();
        DefaultProblemDetailsExceptionHandler.addErrorsOnProblemDetail(validationErrors, body);
        return this.createResponseEntity(ex, new HttpHeaders(), (HttpStatusCode)statusCode, request, body);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ResponseEntity<Object> handleAuthenticationException(AuthenticationException ex, WebRequest request) {
        return this.createDefaultResponseEntity((Exception)ex, new HttpHeaders(), (HttpStatusCode)HttpStatus.UNAUTHORIZED, ex.getMessage(), null, null, request);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Object> handleAuthorizationDeniedException(AccessDeniedException ex, WebRequest request) {
        return this.createDefaultResponseEntity((Exception)ex, new HttpHeaders(), (HttpStatusCode)HttpStatus.FORBIDDEN, ex.getMessage(), null, null, request);
    }

    protected ResponseEntity<Object> createDefaultResponseEntity(Exception ex, HttpHeaders headers, HttpStatusCode statusCode, String defaultDetail, @Nullable String detailMessageCode, Object[] detailMessageArguments, WebRequest request) {
        ProblemDetail body = this.createProblemDetail(ex, statusCode, defaultDetail, detailMessageCode, detailMessageArguments, request);
        return this.createResponseEntity(ex, headers, statusCode, request, body);
    }

    protected static <T> void addValidationErrors(ProblemDetail body, Collection<T> errors, Function<T, FieldMessage> mapper) {
        ValidationErrors validations = new ValidationErrors();
        for (T error : errors) {
            FieldMessage fieldError = mapper.apply(error);
            if (fieldError.field() != null) {
                validations.add(fieldError.field(), fieldError.message());
                continue;
            }
            validations.addGlobal(fieldError.message());
        }
        DefaultProblemDetailsExceptionHandler.addErrorsOnProblemDetail(validations, body);
    }

    private static void addErrorsOnProblemDetail(ValidationErrors validationErrors, ProblemDetail body) {
        Set<ValidationErrors.Error> errors = validationErrors.getErrors();
        Set<String> globalErrors = validationErrors.getGlobalErrors();
        if (!errors.isEmpty()) {
            body.setProperty("errors", errors);
        }
        if (!globalErrors.isEmpty()) {
            body.setProperty("globalErrors", globalErrors);
        }
    }

    protected final ResponseEntity<Object> handleExceptionInternal(@NotNull Exception ex, @Nullable Object body, @NotNull HttpHeaders headers, @NotNull HttpStatusCode statusCode, @NotNull WebRequest request) {
        ResponseEntity response = super.handleExceptionInternal(ex, body, headers, statusCode, request);
        this.precessException(ex, response != null ? response.getBody() : body);
        return response;
    }

    protected final ResponseEntity<Object> createResponseEntity(@NotNull Exception ex, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request, ProblemDetail body) {
        this.precessException(ex, body);
        return this.createResponseEntity(body, headers, statusCode, request);
    }

    protected void updateDefaultTittleAndType(Exception ex, ProblemDetail body) {
        MessageSource messageSource = this.getMessageSource();
        Class<?> clazz = ex.getClass();
        if (messageSource != null) {
            Locale locale = LocaleContextHolder.getLocale();
            body.setTitle(messageSource.getMessage(ErrorResponse.getDefaultTitleMessageCode(clazz), null, null, locale));
            String type = messageSource.getMessage(ErrorResponse.getDefaultTypeMessageCode(clazz), null, null, locale);
            if (type != null) {
                body.setType(URI.create(type));
            }
        }
    }

    private void precessException(Exception ex, Object body) {
        if (this.sendStackTrace && body instanceof ProblemDetail) {
            ProblemDetail problemDetail = (ProblemDetail)body;
            problemDetail.setProperty("stackTrace", (Object)ExceptionUtils.getStackTrace(ex));
        }
    }

    @Generated
    protected boolean isAllErrors() {
        return this.allErrors;
    }

    @Generated
    protected boolean isSendStackTrace() {
        return this.sendStackTrace;
    }

    @Generated
    protected ResponseEntityExceptionHandlerResolver getResolver() {
        return this.resolver;
    }

    @Generated
    protected UncaughtProblemDetailCallback getUncaughtProblemDetailCallback() {
        return this.uncaughtProblemDetailCallback;
    }

    @Generated
    public void setUncaughtProblemDetailCallback(UncaughtProblemDetailCallback uncaughtProblemDetailCallback) {
        this.uncaughtProblemDetailCallback = uncaughtProblemDetailCallback;
    }
}

