/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.web.problemdetails;

import com.peluware.springframework.web.problemdetails.ProblemDetailsException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.util.MultiValueMap;

public class ProblemDetails {
    private final HttpStatusCode status;
    private final HttpHeaders headers = new HttpHeaders();
    private String title;
    private URI type;
    private URI instance;
    private Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public ProblemDetails() {
        this((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public ProblemDetails(HttpStatusCode status) {
        this.status = status;
    }

    public static ProblemDetails status(@NotNull HttpStatusCode httpStatusCode) {
        return new ProblemDetails(httpStatusCode);
    }

    public static ProblemDetails status(int httpStatusCode) {
        return ProblemDetails.status(HttpStatusCode.valueOf((int)httpStatusCode));
    }

    public ProblemDetails title(String title) {
        this.title = title;
        return this;
    }

    public ProblemDetails type(URI type) {
        this.type = type;
        return this;
    }

    public ProblemDetails type(String type) {
        return this.type(URI.create(type));
    }

    public ProblemDetails instance(URI instance) {
        this.instance = instance;
        return this;
    }

    public ProblemDetails instance(String instance) {
        return this.instance(URI.create(instance));
    }

    public ProblemDetails extensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public ProblemDetails extension(String key, Object value) {
        this.extensions.put(key, value);
        return this;
    }

    public ProblemDetails header(String headerName, String ... headersValues) {
        this.headers.addAll(headerName, List.of(headersValues));
        return this;
    }

    public ProblemDetails headers(MultiValueMap<String, String> headers) {
        this.headers.addAll(headers);
        return this;
    }

    public ProblemDetailsException detail(String detail) {
        ProblemDetail problemDetail = this.getProblemDetail(detail);
        return new ProblemDetailsException(problemDetail, this.headers);
    }

    public ProblemDetail getProblemDetail(String detail) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)this.status, (String)detail);
        if (this.type != null) {
            problemDetail.setType(this.type);
        }
        problemDetail.setTitle(this.title);
        problemDetail.setInstance(this.instance);
        if (!this.extensions.isEmpty()) {
            problemDetail.setProperties(this.extensions);
        }
        return problemDetail;
    }

    public static ProblemDetailsException fail(String title, String detail, HttpStatus status) {
        return ProblemDetails.status((HttpStatusCode)status).title(title).detail(detail);
    }

    private static ProblemDetailsException fail(String detail, HttpStatus status) {
        return ProblemDetails.status((HttpStatusCode)status).detail(detail);
    }

    public static ProblemDetailsException notFound(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.NOT_FOUND);
    }

    public static ProblemDetailsException badRequest(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.BAD_REQUEST);
    }

    public static ProblemDetailsException unauthorized(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.UNAUTHORIZED);
    }

    public static ProblemDetailsException forbidden(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.FORBIDDEN);
    }

    public static ProblemDetailsException conflict(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.CONFLICT);
    }

    public static ProblemDetailsException preconditionFailed(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.PRECONDITION_FAILED);
    }

    public static ProblemDetailsException preconditionRequired(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.PRECONDITION_REQUIRED);
    }

    public static ProblemDetailsException tooManyRequests(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.TOO_MANY_REQUESTS);
    }

    public static ProblemDetailsException internalServerError(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static ProblemDetailsException notImplemented(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.NOT_IMPLEMENTED);
    }

    public static ProblemDetailsException serviceUnavailable(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public static ProblemDetailsException gatewayTimeout(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.GATEWAY_TIMEOUT);
    }

    public static ProblemDetailsException badGateway(String title, String detail) {
        return ProblemDetails.fail(title, detail, HttpStatus.BAD_GATEWAY);
    }

    public static ProblemDetailsException notFound(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.NOT_FOUND);
    }

    public static ProblemDetailsException badRequest(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.BAD_REQUEST);
    }

    public static ProblemDetailsException unauthorized(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.UNAUTHORIZED);
    }

    public static ProblemDetailsException forbidden(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.FORBIDDEN);
    }

    public static ProblemDetailsException conflict(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.CONFLICT);
    }

    public static ProblemDetailsException preconditionFailed(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.PRECONDITION_FAILED);
    }

    public static ProblemDetailsException preconditionRequired(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.PRECONDITION_REQUIRED);
    }

    public static ProblemDetailsException tooManyRequests(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.TOO_MANY_REQUESTS);
    }

    public static ProblemDetailsException internalServerError(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static ProblemDetailsException notImplemented(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.NOT_IMPLEMENTED);
    }

    public static ProblemDetailsException serviceUnavailable(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public static ProblemDetailsException gatewayTimeout(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.GATEWAY_TIMEOUT);
    }

    public static ProblemDetailsException badGateway(String detail) {
        return ProblemDetails.fail(detail, HttpStatus.BAD_GATEWAY);
    }

    public static ProblemDetailsException notFound() {
        return ProblemDetails.notFound("Not Found");
    }

    public static ProblemDetailsException badRequest() {
        return ProblemDetails.badRequest("Bad Request");
    }

    public static ProblemDetailsException unauthorized() {
        return ProblemDetails.unauthorized("Unauthorized");
    }

    public static ProblemDetailsException forbidden() {
        return ProblemDetails.forbidden("Forbidden");
    }

    public static ProblemDetailsException conflict() {
        return ProblemDetails.conflict("Conflict");
    }

    public static ProblemDetailsException preconditionFailed() {
        return ProblemDetails.preconditionFailed("Precondition Failed");
    }

    public static ProblemDetailsException preconditionRequired() {
        return ProblemDetails.preconditionRequired("Precondition Required");
    }

    public static ProblemDetailsException tooManyRequests() {
        return ProblemDetails.tooManyRequests("Too Many Requests");
    }

    public static ProblemDetailsException internalServerError() {
        return ProblemDetails.internalServerError("Internal Server Error");
    }

    public static ProblemDetailsException notImplemented() {
        return ProblemDetails.notImplemented("Not Implemented");
    }

    public static ProblemDetailsException serviceUnavailable() {
        return ProblemDetails.serviceUnavailable("Service Unavailable");
    }

    public static ProblemDetailsException gatewayTimeout() {
        return ProblemDetails.gatewayTimeout("Gateway Timeout");
    }

    public static ProblemDetailsException badGateway() {
        return ProblemDetails.badGateway("Bad Gateway");
    }

    @Generated
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public URI getType() {
        return this.type;
    }

    @Generated
    public URI getInstance() {
        return this.instance;
    }

    @Generated
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }
}

