/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.web.problemdetails;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

public class ResponseEntityExceptionHandlerResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseEntityExceptionHandlerResolver.class);
    private final ApplicationContext applicationContext;
    private final Map<Class<?>, Object> controllerAdviceBeans = new HashMap();
    private final Map<Class<? extends Exception>, Method> exceptionHandlerMethods = new HashMap<Class<? extends Exception>, Method>();
    private final Map<Class<? extends Exception>, Method> handlerMethodCache = new ConcurrentHashMap<Class<? extends Exception>, Method>();

    @EventListener(value={ApplicationStartedEvent.class})
    private void initializeExceptionHandlers() {
        Map controllerAdviceBeansMap = this.applicationContext.getBeansWithAnnotation(ControllerAdvice.class);
        Map restControllerAdviceBeansMap = this.applicationContext.getBeansWithAnnotation(RestControllerAdvice.class);
        controllerAdviceBeansMap.putAll(restControllerAdviceBeansMap);
        if (log.isDebugEnabled()) {
            controllerAdviceBeansMap.forEach((key, value) -> log.debug("Found controller advice bean: {}", key));
        }
        controllerAdviceBeansMap.forEach((beanName, bean) -> {
            Class<?> beanClass = bean.getClass();
            Arrays.stream(beanClass.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers()) && method.canAccess(bean) && method.isAnnotationPresent(ExceptionHandler.class)).forEach(method -> {
                Class<?>[] exceptionTypes = method.getParameterTypes();
                if (exceptionTypes.length == 2 && Exception.class.isAssignableFrom(exceptionTypes[0]) && WebRequest.class.isAssignableFrom(exceptionTypes[1]) && ResponseEntityExceptionHandlerResolver.isResponseEntityOfTypeObject(method)) {
                    log.debug("Found exception handler method: {} in bean: {}", (Object)method.getName(), beanName);
                    Class<?> exceptionClass = exceptionTypes[0];
                    this.exceptionHandlerMethods.put((Class<? extends Exception>)exceptionClass, (Method)method);
                    this.controllerAdviceBeans.put(beanClass, bean);
                }
            });
        });
    }

    private static boolean isResponseEntityOfTypeObject(Method method) {
        if (method.getReturnType().equals(ResponseEntity.class)) {
            ParameterizedType genericReturnType = (ParameterizedType)method.getGenericReturnType();
            return genericReturnType.getActualTypeArguments()[0].equals(Object.class);
        }
        return false;
    }

    public ResponseEntity<Object> handleException(Exception exception, WebRequest webRequest) throws NoSuchMethodException {
        Class<?> exceptionClass = exception.getClass();
        Method handlerMethod = this.findHandlerMethod(exceptionClass);
        if (handlerMethod == null) {
            throw new NoSuchMethodException("No handler found for exception: " + exception.getClass().getName());
        }
        try {
            Object controllerAdviceBean = this.controllerAdviceBeans.get(handlerMethod.getDeclaringClass());
            return (ResponseEntity)handlerMethod.invoke(controllerAdviceBean, exception, webRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error invoking exception handler method", e);
        }
    }

    private Method findHandlerMethod(Class<? extends Exception> exceptionClass) {
        if (this.handlerMethodCache.containsKey(exceptionClass)) {
            return this.handlerMethodCache.get(exceptionClass);
        }
        Method closestHandlerMethod = null;
        for (Class<? extends Exception> currentClass = exceptionClass; currentClass != null && closestHandlerMethod == null; currentClass = currentClass.getSuperclass()) {
            closestHandlerMethod = this.exceptionHandlerMethods.get(currentClass);
        }
        this.handlerMethodCache.put(exceptionClass, closestHandlerMethod);
        return closestHandlerMethod;
    }

    @Generated
    public ResponseEntityExceptionHandlerResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

