/*
 * Decompiled with CFR 0.152.
 */
package com.peluware.springframework.web.problemdetails.schemas;

import com.peluware.springframework.web.problemdetails.ValidationException;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class ValidationErrors {
    private final Set<Error> errors = new HashSet<Error>();
    private final Set<String> globalErrors = new HashSet<String>();

    public void add(String field, String message) {
        Error error = this.errors.stream().filter(err -> err.field().equals(field)).findFirst().orElseGet(() -> {
            Error newError = new Error(field);
            this.errors.add(newError);
            return newError;
        });
        error.messages().add(message);
    }

    public void addThrow(String field, String message) {
        this.add(field, message);
        this.throwThis();
    }

    public void addGlobal(String message) {
        this.globalErrors.add(message);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty() || !this.globalErrors.isEmpty();
    }

    public void throwIfHasErrors() {
        if (this.hasErrors()) {
            this.throwThis();
        }
    }

    private void throwThis() {
        throw new ValidationException(this);
    }

    @Generated
    public ValidationErrors() {
    }

    @Generated
    public Set<Error> getErrors() {
        return this.errors;
    }

    @Generated
    public Set<String> getGlobalErrors() {
        return this.globalErrors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationErrors)) {
            return false;
        }
        ValidationErrors other = (ValidationErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Error> this$errors = this.getErrors();
        Set<Error> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        Set<String> this$globalErrors = this.getGlobalErrors();
        Set<String> other$globalErrors = other.getGlobalErrors();
        return !(this$globalErrors == null ? other$globalErrors != null : !((Object)this$globalErrors).equals(other$globalErrors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationErrors;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Error> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        Set<String> $globalErrors = this.getGlobalErrors();
        result = result * 59 + ($globalErrors == null ? 43 : ((Object)$globalErrors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationErrors(errors=" + String.valueOf(this.getErrors()) + ", globalErrors=" + String.valueOf(this.getGlobalErrors()) + ")";
    }

    public record Error(String field, Set<String> messages) {
        private Error(String field) {
            this(field, new HashSet<String>());
        }
    }
}

