/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import android.util.Log;
import com.percolate.foam.CrashReportingService;
import com.percolate.foam.DeleteFileCallback;
import com.percolate.foam.ExceptionPersister;
import com.percolate.foam.Service;
import com.percolate.foam.StoredException;
import com.percolate.foam.Utils;
import java.util.List;
import java.util.Map;

class CustomExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Context context;
    Utils utils;
    private List<CrashReportingService> services;
    private boolean wifiOnly;
    ExceptionPersister exceptionPersister;
    Thread.UncaughtExceptionHandler defaultHandler;

    CustomExceptionHandler(Context context, List<CrashReportingService> crashReportingServices, boolean wifiOnly) {
        this.context = context;
        this.utils = new Utils();
        this.services = crashReportingServices;
        this.wifiOnly = wifiOnly;
        this.defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.exceptionPersister = new ExceptionPersister(context);
    }

    void start() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.sendStoredExceptions();
    }

    void stop() {
        Thread.setDefaultUncaughtExceptionHandler(this.defaultHandler);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.storeException(thread, ex);
        this.defaultHandler.uncaughtException(thread, ex);
    }

    void storeException(Thread thread, Throwable ex) {
        String stackTrace = this.utils.trimToSize(this.getStackTraceString(ex), 1024);
        for (Service service : this.services) {
            if (!service.isEnabled()) continue;
            this.exceptionPersister.store(new StoredException(service.getServiceType(), ex.getMessage(), thread.getName(), stackTrace));
        }
    }

    String getStackTraceString(Throwable ex) {
        return Log.getStackTraceString((Throwable)ex);
    }

    void sendStoredExceptions() {
        Map<String, StoredException> storedExceptions;
        if ((!this.wifiOnly || this.utils.isOnWifi(this.context)) && (storedExceptions = this.getStoredExceptions()) != null) {
            for (Map.Entry<String, StoredException> entry : storedExceptions.entrySet()) {
                String fileName = entry.getKey();
                StoredException storedException = entry.getValue();
                for (CrashReportingService service : this.services) {
                    if (!service.isEnabled()) continue;
                    DeleteFileCallback callback = new DeleteFileCallback(this.context, fileName);
                    service.logEvent(storedException, callback);
                }
            }
        }
    }

    Map<String, StoredException> getStoredExceptions() {
        if (this.exceptionPersister != null) {
            return this.exceptionPersister.loadAll();
        }
        return null;
    }

    boolean isRunning() {
        return Thread.getDefaultUncaughtExceptionHandler() == this;
    }
}

