/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.FoamDontTrack;
import com.percolate.foam.Utils;
import java.lang.reflect.Method;
import java.util.List;

class EventTracker {
    private Context context;
    Utils utils;
    private List<EventTrackingService> services;
    private boolean wifiOnly;
    private Application.ActivityLifecycleCallbacks callbacks;
    private boolean callbacksIsRegistered = false;

    public EventTracker(Context context, List<EventTrackingService> services, boolean wifiOnly) {
        this.context = context;
        this.utils = new Utils();
        this.services = services;
        this.wifiOnly = wifiOnly;
        this.callbacks = this.createActivityLifecycleCallback();
    }

    public void start() {
        if (this.context instanceof Application) {
            ((Application)this.context).registerActivityLifecycleCallbacks(this.callbacks);
            this.callbacksIsRegistered = true;
        } else {
            this.utils.logIssue("EventTracker could not start.  Context is not of type Application", null);
        }
    }

    Application.ActivityLifecycleCallbacks createActivityLifecycleCallback() {
        return new Application.ActivityLifecycleCallbacks(){

            public void onActivityResumed(Activity activity) {
                EventTracker.this.trackActivity(activity);
            }

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
    }

    void trackActivity(Activity activity) {
        if (this.shouldTrack(activity)) {
            String activityName = activity.getClass().getSimpleName();
            this.trackEvent((Context)activity, activityName);
        }
    }

    void trackEvent(Context context, String event) {
        for (EventTrackingService service : this.services) {
            if (!service.isEnabled()) continue;
            service.logEvent(context, event);
        }
    }

    boolean shouldTrack(Activity activity) {
        if (this.wifiOnly && !this.utils.isOnWifi(this.context)) {
            return false;
        }
        if (activity != null) {
            Class<?> clazz = activity.getClass();
            if (clazz.isAnnotationPresent(FoamDontTrack.class)) {
                return false;
            }
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(FoamDontTrack.class)) continue;
                return false;
            }
        }
        return true;
    }

    void stop() {
        if (this.context instanceof Application) {
            ((Application)this.context).unregisterActivityLifecycleCallbacks(this.callbacks);
            this.callbacksIsRegistered = false;
        }
    }

    boolean isRunning() {
        return this.callbacksIsRegistered;
    }
}

