/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.percolate.foam.StoredException;
import com.percolate.foam.Utils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class ExceptionPersister {
    private Context context;
    Utils utils;

    public ExceptionPersister(Context context) {
        this.context = context;
        this.utils = new Utils();
    }

    public Map<String, StoredException> loadAll() {
        String[] fileNames;
        HashMap<String, StoredException> storedExceptions = new HashMap<String, StoredException>();
        if (this.context != null && (fileNames = this.context.fileList()) != null) {
            for (String fileName : fileNames) {
                StoredException storedException;
                if (!this.utils.isNotBlank(fileName) || !fileName.startsWith("FoamStoredException") || (storedException = this.loadStoredExceptionData(fileName)) == null) continue;
                storedExceptions.put(fileName, storedException);
            }
        }
        return storedExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    StoredException loadStoredExceptionData(String fileName) {
        StoredException storedException = null;
        FileInputStream in = null;
        try {
            in = this.context.openFileInput(fileName);
            if (in != null) {
                InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");
                Gson gson = new Gson();
                storedException = (StoredException)gson.fromJson((Reader)reader, StoredException.class);
            }
        }
        catch (Exception ex) {
            this.utils.logIssue("Could not load file [" + fileName + "]", ex);
        }
        finally {
            this.closeStream(in);
        }
        return storedException;
    }

    void closeStream(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            this.utils.logIssue("Could not close exception storage file.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(StoredException storedException) {
        String fileName = "FoamStoredException-" + storedException.platform.toString() + System.currentTimeMillis() + new Random().nextInt();
        FileOutputStream out = null;
        try {
            String json = new Gson().toJson((Object)storedException);
            out = this.context.openFileOutput(fileName, 0);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "ISO8859_1");
            writer.write(json);
            writer.flush();
            this.closeStream(out);
        }
        catch (Exception ex) {
            this.utils.logIssue("Could not write exception to a file.", ex);
        }
        finally {
            this.closeStream(out);
        }
    }
}

