/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.flurry.android.FlurryAgent;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;

class Flurry
extends ServiceImpl
implements EventTrackingService {
    private String applicationKey;

    public Flurry(Context context) {
        super(context);
    }

    @Override
    public void enable(String applicationKey) {
        this.applicationKey = applicationKey;
        if (this.utils.isNotBlank(this.applicationKey)) {
            this.initFlurryAgent();
        }
    }

    void initFlurryAgent() {
        FlurryAgent.setVersionName((String)this.utils.getVersionName(this.context));
        FlurryAgent.setUserId((String)this.utils.getAndroidId(this.context));
        FlurryAgent.setCaptureUncaughtExceptions((boolean)true);
        FlurryAgent.init((Context)this.context, (String)this.applicationKey);
    }

    @Override
    public boolean isEnabled() {
        return this.utils.isNotBlank(this.applicationKey);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.FLURRY;
    }

    @Override
    public void logEvent(Context context, String event) {
        FlurryAgent.onStartSession((Context)context);
        FlurryAgent.logEvent((String)event);
        FlurryAgent.onEndSession((Context)context);
    }

    public boolean checkForJar() {
        try {
            this.checkForClass("com.flurry.android.FlurryAgent");
            return true;
        }
        catch (ClassNotFoundException ex) {
            this.utils.logIssue("\n\n\nFoam: You must add the FlurryAnalytics-x.x.x.jar file to your application to enable flurry analytics.  This can be found at https://dev.flurry.com under Applications Tab -> Select your application -> Manage -> 'Download SDK'.\n\n\n", ex);
            return false;
        }
    }

    void checkForClass(String clazz) throws ClassNotFoundException {
        Class.forName(clazz, false, this.getClass().getClassLoader());
    }
}

