/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.app.Application;
import android.content.Context;
import com.percolate.foam.FoamApiKeys;
import com.percolate.foam.FoamMain;
import com.percolate.foam.Utils;

class FoamApplicationInit {
    FoamMain foamMain;
    Application application;
    Utils utils;

    public FoamApplicationInit(Application application) {
        this.foamMain = new FoamMain((Context)application);
        this.application = application;
        this.utils = new Utils();
    }

    public FoamMain init() {
        if (this.application != null) {
            FoamApiKeys foamApiKeys = this.getFoamApiKeys();
            if (foamApiKeys != null) {
                this.foamMain.init(foamApiKeys);
                this.foamMain.start();
            } else {
                this.utils.logIssue("Please add @FoamApiKeys to " + this.application.getClass().getName(), null);
            }
        }
        return this.foamMain;
    }

    FoamApiKeys getFoamApiKeys() {
        if (this.application.getClass().isAnnotationPresent(FoamApiKeys.class)) {
            return this.application.getClass().getAnnotation(FoamApiKeys.class);
        }
        return null;
    }
}

