/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.percolate.foam.CrashReportingService;
import com.percolate.foam.CustomExceptionHandler;
import com.percolate.foam.EventTracker;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.Flurry;
import com.percolate.foam.FoamApiKeys;
import com.percolate.foam.GoogleAnalytics;
import com.percolate.foam.Graphite;
import com.percolate.foam.HockeyApp;
import com.percolate.foam.LogEntries;
import com.percolate.foam.LogListener;
import com.percolate.foam.LoggingService;
import com.percolate.foam.Mixpanel;
import com.percolate.foam.PagerDuty;
import com.percolate.foam.PaperTrail;
import com.percolate.foam.Service;
import com.percolate.foam.ServiceType;
import com.percolate.foam.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FoamMain {
    private Context context;
    FoamApiKeys foamApiKeys;
    Map<ServiceType, Service> services = new HashMap<ServiceType, Service>();
    EventTracker eventTracker;
    CustomExceptionHandler customExceptionHandler;
    LogListener logListener;

    FoamMain(Context context) {
        this.context = context;
    }

    protected void init(FoamApiKeys foamApiKeys) {
        this.foamApiKeys = foamApiKeys;
        this.services.put(ServiceType.PAGERDUTY, new PagerDuty(this.context));
        this.services.put(ServiceType.HOCKEYAPP, new HockeyApp(this.context));
        this.services.put(ServiceType.PAPERTRAIL, new PaperTrail(this.context));
        this.services.put(ServiceType.LOGENTRIES, new LogEntries(this.context));
        this.services.put(ServiceType.MIXPANEL, new Mixpanel(this.context));
        this.services.put(ServiceType.FLURRY, new Flurry(this.context));
        this.services.put(ServiceType.GOOGLE_ANALYTICS, new GoogleAnalytics(this.context));
        this.services.put(ServiceType.GRAPHITE, new Graphite(this.context));
    }

    void start() {
        this.initializeServices();
        this.startCustomExceptionHandler();
        this.startLogListener();
        this.startEventTracker();
    }

    void stop() {
        if (this.eventTracker != null) {
            this.eventTracker.stop();
        }
        if (this.customExceptionHandler != null) {
            this.customExceptionHandler.stop();
        }
        if (this.logListener != null) {
            this.logListener.stop();
        }
    }

    void initializeServices() {
        for (Map.Entry<ServiceType, Service> entry : this.services.entrySet()) {
            ServiceType serviceType = entry.getKey();
            Service service = entry.getValue();
            String apiKey = null;
            if (serviceType == ServiceType.PAGERDUTY) {
                apiKey = this.foamApiKeys.pagerDuty();
            } else if (serviceType == ServiceType.HOCKEYAPP) {
                apiKey = this.foamApiKeys.hockeyApp();
            } else if (serviceType == ServiceType.PAPERTRAIL) {
                apiKey = this.foamApiKeys.papertrail();
            } else if (serviceType == ServiceType.LOGENTRIES) {
                apiKey = this.foamApiKeys.logentries();
            } else if (serviceType == ServiceType.MIXPANEL) {
                apiKey = this.foamApiKeys.mixpanel();
            } else if (serviceType == ServiceType.GOOGLE_ANALYTICS) {
                apiKey = this.foamApiKeys.googleAnalytics();
            } else if (serviceType == ServiceType.FLURRY) {
                if (((Flurry)service).checkForJar()) {
                    apiKey = this.foamApiKeys.flurry();
                }
            } else if (serviceType == ServiceType.GRAPHITE) {
                apiKey = this.foamApiKeys.graphite();
            }
            if (!new Utils().isNotBlank(apiKey)) continue;
            service.enable(apiKey);
        }
    }

    void startCustomExceptionHandler() {
        List<CrashReportingService> services = this.getEnabledServicesForType(CrashReportingService.class);
        if (services != null && !services.isEmpty()) {
            if (this.customExceptionHandler == null) {
                this.customExceptionHandler = new CustomExceptionHandler(this.context, services, this.foamApiKeys.wifiOnly());
            }
            if (!this.customExceptionHandler.isRunning()) {
                this.customExceptionHandler.start();
            }
        }
    }

    void startLogListener() {
        List<LoggingService> services = this.getEnabledServicesForType(LoggingService.class);
        if (services != null && !services.isEmpty()) {
            if (this.logListener == null) {
                this.logListener = new LogListener(this.context, services, this.foamApiKeys.wifiOnly());
            }
            if (!this.logListener.isRunning()) {
                this.logListener.start();
            }
        }
    }

    void startEventTracker() {
        List<EventTrackingService> services = this.getEnabledServicesForType(EventTrackingService.class);
        if (services != null && !services.isEmpty()) {
            if (this.eventTracker == null) {
                this.eventTracker = new EventTracker(this.context, services, this.foamApiKeys.wifiOnly());
            }
            if (!this.eventTracker.isRunning()) {
                this.eventTracker.start();
            }
        }
    }

    <T extends Service> List<T> getEnabledServicesForType(Class<T> clazz) {
        ArrayList<Service> servicesOfType = new ArrayList<Service>();
        if (this.services != null && !this.services.isEmpty()) {
            for (Service service : this.services.values()) {
                if (!clazz.isAssignableFrom(service.getClass()) || !service.isEnabled()) continue;
                servicesOfType.add(service);
            }
        }
        return servicesOfType;
    }

    void logEvent(Context context, String event) {
        if (this.eventTracker != null) {
            this.eventTracker.trackEvent(context, event);
        }
    }
}

