/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.NoOpCallback;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.client.Response;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.http.Body;
import retrofit.http.POST;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;
import retrofit.mime.TypedString;

class GoogleAnalytics
extends ServiceImpl
implements EventTrackingService {
    String trackingId;
    GoogleAnalyticsService googleAnalyticsService;

    GoogleAnalytics(Context context) {
        super(context);
    }

    @Override
    public void enable(String trackingId) {
        this.trackingId = trackingId;
    }

    @Override
    public boolean isEnabled() {
        return this.utils.isNotBlank(this.trackingId);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.GOOGLE_ANALYTICS;
    }

    @Override
    public void logEvent(Context context, String event) {
        try {
            String payload = this.createPayloadData(event);
            this.createService().createEvent(payload, new NoOpCallback());
        }
        catch (Exception ex) {
            this.utils.logIssue("Could not send google analytics data", ex);
        }
    }

    GoogleAnalyticsService createService() {
        if (this.googleAnalyticsService == null) {
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://www.google-analytics.com").setConverter((Converter)new StringConverter()).build();
            this.googleAnalyticsService = (GoogleAnalyticsService)restAdapter.create(GoogleAnalyticsService.class);
        }
        return this.googleAnalyticsService;
    }

    String createPayloadData(String event) {
        String payload = null;
        try {
            String androidId = this.utils.getAndroidId(this.context);
            UUID deviceUUID = UUID.nameUUIDFromBytes(androidId.getBytes("utf8"));
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("v", "1");
            data.put("tid", this.trackingId);
            data.put("cid", deviceUUID.toString());
            data.put("t", "screenview");
            data.put("an", this.utils.getApplicationName(this.context));
            data.put("av", this.utils.getVersionName(this.context));
            data.put("aid", this.utils.getApplicationPackageName(this.context));
            data.put("cd", event);
            StringBuilder sb = new StringBuilder(8192);
            for (Map.Entry entry : data.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append((String)entry.getValue());
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
            payload = new String(sb.toString().getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.utils.logIssue("Encoding exception", ex);
        }
        catch (Exception ex) {
            this.utils.logIssue("Error creating google analytics payload data", ex);
        }
        return payload;
    }

    static class StringConverter
    implements Converter {
        StringConverter() {
        }

        public Object fromBody(TypedInput typedInput, Type type) throws ConversionException {
            String text = null;
            try {
                String line;
                typedInput.in();
                BufferedReader reader = new BufferedReader(new InputStreamReader(typedInput.in()));
                StringBuilder out = new StringBuilder();
                String newLine = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                    out.append(newLine);
                }
                text = out.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return text;
        }

        public TypedOutput toBody(Object output) {
            return new TypedString(output.toString());
        }
    }

    static interface GoogleAnalyticsService {
        @POST(value="/collect")
        public void createEvent(@Body String var1, Callback<Response> var2);
    }
}

