/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

class Graphite
extends ServiceImpl
implements EventTrackingService {
    String host;
    int port;
    String apiKey;

    Graphite(Context context) {
        super(context);
    }

    @Override
    public void enable(String url) {
        if (this.utils.isNotBlank(url) && url.contains(":") && url.split(":").length == 2) {
            String first = url.split(":")[0];
            String second = url.split(":")[1];
            if (first.contains("@")) {
                this.apiKey = first.split("@")[0];
                this.host = first.split("@")[1];
            } else {
                this.host = url.split(":")[0];
            }
            try {
                this.port = Integer.parseInt(second);
            }
            catch (NumberFormatException ex) {
                this.utils.logIssue("Invalid port in Graphite URL [" + second + "]", ex);
            }
        } else {
            this.utils.logIssue("Invalid Graphite URL.  Expecting \"[key@]host:port\" format.", null);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.host != null && this.port != 0;
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.GRAPHITE;
    }

    @Override
    public void logEvent(Context context, String event) {
        StringBuilder eventData = new StringBuilder();
        if (this.utils.isNotBlank(this.apiKey)) {
            eventData.append(this.apiKey);
            eventData.append(".");
        }
        eventData.append(this.utils.getApplicationPackageName(context));
        eventData.append(".");
        eventData.append(event);
        eventData.append(" 1 ");
        eventData.append(this.getTimeStamp());
        eventData.append("\n");
        this.sendData(eventData.toString());
    }

    long getTimeStamp() {
        return System.currentTimeMillis() / 1000L;
    }

    void sendData(final String graphiteEvent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Graphite.this.sendUdpData(graphiteEvent);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUdpData(String graphiteEvent) {
        Socket socket = null;
        try {
            socket = this.sendDataOverSocket(graphiteEvent);
        }
        catch (IOException ex) {
            this.utils.logIssue("Error sending graphite event [" + graphiteEvent + "] to [" + this.host + ":" + this.port + "].", ex);
        }
        finally {
            this.closeSocket(socket);
        }
    }

    Socket sendDataOverSocket(String graphiteEvent) throws IOException {
        Socket socket = new Socket(this.host, this.port);
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        dos.writeBytes(graphiteEvent);
        dos.flush();
        return socket;
    }

    void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                this.utils.logIssue("Could not close graphite socket [" + this.host + ":" + this.port + "].", ex);
            }
        }
    }
}

