/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import android.os.Build;
import com.percolate.foam.CrashReportingService;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;
import com.percolate.foam.StoredException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Multipart;
import retrofit.http.POST;
import retrofit.http.Part;
import retrofit.http.Path;
import retrofit.mime.TypedFile;

class HockeyApp
extends ServiceImpl
implements CrashReportingService {
    private String apiKey;
    private SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    protected HockeyAppService hockeyAppService;

    HockeyApp(Context context) {
        super(context);
    }

    @Override
    public void enable(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public boolean isEnabled() {
        return this.utils.isNotBlank(this.apiKey);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.HOCKEYAPP;
    }

    @Override
    public void logEvent(final StoredException storedException, final Callback<Object> deleteStoredExceptionCallback) {
        this.createService().getApps(this.apiKey, new Callback<HockeyAppsDTO>(){

            public void success(HockeyAppsDTO appsList, Response response) {
                String appId = HockeyApp.this.getAppIDFromResponse(appsList);
                if (HockeyApp.this.utils.isNotBlank(appId)) {
                    HockeyApp.this.createLogEvent(appId, storedException, (Callback<Object>)deleteStoredExceptionCallback);
                }
            }

            public void failure(RetrofitError error) {
                HockeyApp.this.utils.logIssue("Error getting HockeyApp list of apps", (Throwable)error);
            }
        });
    }

    public HockeyAppService createService() {
        if (this.hockeyAppService == null) {
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://rink.hockeyapp.net").build();
            this.hockeyAppService = (HockeyAppService)restAdapter.create(HockeyAppService.class);
        }
        return this.hockeyAppService;
    }

    protected String getAppIDFromResponse(HockeyAppsDTO appsList) {
        String applicationPackageName = this.utils.getApplicationPackageName(this.context);
        String hockeyAppApplicationId = null;
        if (appsList != null && appsList.apps != null && !appsList.apps.isEmpty()) {
            for (HockeyAppDTO app : appsList.apps) {
                if (app.bundle_identifier == null || app.public_identifier == null || !"Android".equalsIgnoreCase(app.platform) || !app.bundle_identifier.equals(applicationPackageName)) continue;
                hockeyAppApplicationId = app.public_identifier;
                break;
            }
        }
        return hockeyAppApplicationId;
    }

    void createLogEvent(String appId, StoredException storedException, Callback<Object> deleteStoredExceptionCallback) {
        File logFile = this.writeHockeyAppCrashLog(storedException.stackTrace);
        if (logFile != null && logFile.exists()) {
            TypedFile log = new TypedFile("text/plain", logFile);
            this.createService().createEvent(appId, log, this.createLogEventCallback(deleteStoredExceptionCallback, logFile));
        }
    }

    Callback<Response> createLogEventCallback(final Callback<Object> deleteStoredExceptionCallback, final File logFile) {
        return new Callback<Response>(){

            public void success(Response resp, Response response) {
                if (!logFile.delete()) {
                    HockeyApp.this.utils.logIssue("Unable to clean up temp HockeyApp file", null);
                }
                if (deleteStoredExceptionCallback != null) {
                    deleteStoredExceptionCallback.success((Object)resp, response);
                }
            }

            public void failure(RetrofitError error) {
                if (!logFile.delete()) {
                    HockeyApp.this.utils.logIssue("Unable to clean up temp HockeyApp file", null);
                }
                if (deleteStoredExceptionCallback != null) {
                    deleteStoredExceptionCallback.failure(error);
                }
            }
        };
    }

    File writeHockeyAppCrashLog(String stackTrace) {
        File logFile = null;
        try {
            File outputDir = this.context.getCacheDir();
            logFile = File.createTempFile("hockey_app_crash_", ".log", outputDir);
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile));
            writer.write("Package: " + this.utils.getApplicationPackageName(this.context) + "\n");
            writer.write("Version Code: " + this.utils.getVersionCode(this.context) + "\n");
            writer.write("Version Name: " + this.utils.getVersionName(this.context) + "\n");
            writer.write("Android: " + Build.VERSION.RELEASE + "\n");
            writer.write("Manufacturer: " + Build.MANUFACTURER + "\n");
            writer.write("Model: " + Build.MODEL + "\n");
            writer.write("Date: " + this.getTimestamp() + "\n");
            writer.write("\n");
            writer.write(stackTrace);
            writer.close();
        }
        catch (Exception ex) {
            this.utils.logIssue("Error writing crash report to temp log file", ex);
        }
        return logFile;
    }

    String getTimestamp() {
        return this.df.format(new Date());
    }

    class HockeyAppDTO {
        protected Integer id;
        protected String bundle_identifier;
        protected String public_identifier;
        protected String platform;
        protected Integer release_type;
        protected String custom_release_type;
        protected String created_at;
        protected String updated_at;
        protected String minimum_os_version;
        protected Integer status;
        protected String owner;
        protected String owner_token;
        protected String company;

        HockeyAppDTO() {
        }
    }

    class HockeyAppsDTO {
        List<HockeyAppDTO> apps;

        HockeyAppsDTO() {
        }
    }

    protected static interface HockeyAppService {
        @GET(value="/api/2/apps")
        public void getApps(@Header(value="X-HockeyAppToken") String var1, Callback<HockeyAppsDTO> var2);

        @Multipart
        @POST(value="/api/2/apps/{APP_ID}/crashes/upload")
        public void createEvent(@Path(value="APP_ID") String var1, @Part(value="log") TypedFile var2, Callback<Response> var3);
    }
}

