/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import android.os.AsyncTask;
import com.percolate.foam.LoggingService;
import com.percolate.foam.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class LogListener {
    private Context context;
    protected Utils utils;
    private List<LoggingService> services;
    private boolean wifiOnly;
    protected boolean stop = true;
    private int pollFrequencyMs = 5000;

    LogListener(Context context, List<LoggingService> services, boolean wifiOnly) {
        this.context = context;
        this.utils = new Utils();
        this.services = services;
        this.wifiOnly = wifiOnly;
    }

    public void start() {
        this.stop = false;
        this.startMonitoringLogcat();
    }

    protected void startMonitoringLogcat() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                while (!LogListener.this.stop) {
                    LogListener.this.processNewLogs();
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    protected void processNewLogs() {
        List<String> logs = this.getNewLogs();
        this.processLogEntries(logs);
        this.utils.sleep(this.pollFrequencyMs);
    }

    List<String> getNewLogs() {
        ArrayList<String> logs = new ArrayList<String>();
        try {
            String line;
            Process logcatProcess = this.runLogcatCommand("-d");
            InputStreamReader stream = new InputStreamReader(logcatProcess.getInputStream());
            BufferedReader reader = new BufferedReader(stream);
            while ((line = reader.readLine()) != null) {
                logs.add(line);
            }
            this.runLogcatCommand("-c");
        }
        catch (Exception ex) {
            this.utils.logIssue("Error trying to read logcat output", ex);
        }
        return logs;
    }

    Process runLogcatCommand(String commandLineArgs) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"logcat", commandLineArgs});
    }

    protected void processLogEntries(List<String> logs) {
        if (!this.wifiOnly || this.utils.isOnWifi(this.context)) {
            for (String log : logs) {
                if (log == null || !log.startsWith("E")) continue;
                for (LoggingService service : this.services) {
                    if (!service.isEnabled()) continue;
                    service.logEvent(log);
                }
            }
        }
    }

    void stop() {
        this.stop = true;
    }

    boolean isRunning() {
        return !this.stop;
    }
}

