/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import android.util.Base64;
import com.google.gson.Gson;
import com.percolate.foam.EventTrackingService;
import com.percolate.foam.NoOpCallback;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;
import java.util.HashMap;
import java.util.Map;
import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.client.Response;
import retrofit.http.GET;
import retrofit.http.Query;

class Mixpanel
extends ServiceImpl
implements EventTrackingService {
    private String projectToken;
    protected MixpanelService mixpanelService;

    Mixpanel(Context context) {
        super(context);
    }

    @Override
    public void enable(String projectToken) {
        this.projectToken = projectToken;
    }

    @Override
    public boolean isEnabled() {
        return this.utils.isNotBlank(this.projectToken);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.MIXPANEL;
    }

    @Override
    public void logEvent(Context context, String eventName) {
        MixpanelEvent event = new MixpanelEvent();
        event.event = eventName;
        event.properties.put("token", this.projectToken);
        event.properties.put("distinct_id", this.utils.getAndroidId(context));
        String data = this.eventObjToBase64(event);
        this.createService().trackEvent(data, new NoOpCallback());
    }

    protected MixpanelService createService() {
        if (this.mixpanelService == null) {
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://api.mixpanel.com").build();
            this.mixpanelService = (MixpanelService)restAdapter.create(MixpanelService.class);
        }
        return this.mixpanelService;
    }

    protected String eventObjToBase64(MixpanelEvent event) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)event);
        return this.toBase64(json.getBytes());
    }

    protected String toBase64(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)0);
    }

    protected class MixpanelEvent {
        String event;
        Map<String, String> properties = new HashMap<String, String>();

        protected MixpanelEvent() {
        }
    }

    protected static interface MixpanelService {
        @GET(value="/track/")
        public void trackEvent(@Query(value="data") String var1, Callback<Response> var2);
    }
}

