/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.percolate.foam.CrashReportingService;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.ServiceType;
import com.percolate.foam.StoredException;
import java.util.LinkedHashMap;
import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.http.Body;
import retrofit.http.POST;

class PagerDuty
extends ServiceImpl
implements CrashReportingService {
    protected String apiKey;
    protected PagerDutyService pagerDutyService;

    PagerDuty(Context context) {
        super(context);
    }

    @Override
    public void enable(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public boolean isEnabled() {
        return this.utils.isNotBlank(this.apiKey);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.PAGERDUTY;
    }

    @Override
    public void logEvent(StoredException storedException, Callback<Object> callback) {
        PagerDutyEvent pagerDutyEvent = this.createEvent(storedException);
        this.createService().createEvent(pagerDutyEvent, callback);
    }

    PagerDutyService createService() {
        if (this.pagerDutyService == null) {
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://events.pagerduty.com").build();
            this.pagerDutyService = (PagerDutyService)restAdapter.create(PagerDutyService.class);
        }
        return this.pagerDutyService;
    }

    PagerDutyEvent createEvent(StoredException storedException) {
        PagerDutyEvent pagerDutyEvent = new PagerDutyEvent();
        pagerDutyEvent.service_key = this.apiKey;
        pagerDutyEvent.event_type = "trigger";
        pagerDutyEvent.incident_key = storedException.message;
        pagerDutyEvent.description = storedException.stackTrace;
        return pagerDutyEvent;
    }

    class PagerDutyEvent {
        protected String service_key;
        protected String event_type;
        protected String incident_key;
        protected String description;
        protected String client;
        protected String client_url;
        protected LinkedHashMap<String, Object> details;

        PagerDutyEvent() {
        }
    }

    static interface PagerDutyService {
        @POST(value="/generic/2010-04-15/create_event.json")
        public void createEvent(@Body PagerDutyEvent var1, Callback<Object> var2);
    }
}

