/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.Context;
import com.percolate.foam.CrashReportingService;
import com.percolate.foam.LoggingService;
import com.percolate.foam.ServiceImpl;
import com.percolate.foam.StoredException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import retrofit.Callback;

abstract class UDPLoggingService
extends ServiceImpl
implements CrashReportingService,
LoggingService {
    private String url;
    private String host;
    private int port = -1;

    UDPLoggingService(Context context) {
        super(context);
    }

    @Override
    public void enable(String url) {
        this.url = url;
        if (url.contains(":") && url.split(":").length == 2) {
            this.host = url.split(":")[0];
            try {
                this.port = Integer.parseInt(url.split(":")[1]);
            }
            catch (NumberFormatException nfe) {
                this.utils.logIssue("Could not get port number from url [" + url + "]", nfe);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.url != null && this.host != null && this.port != -1;
    }

    @Override
    public void logEvent(StoredException storedException, Callback<Object> callback) {
        this.sendLogEvent(storedException.threadName, storedException.stackTrace, callback);
    }

    @Override
    public void logEvent(String log) {
        this.sendLogEvent("Log", log, null);
    }

    protected void sendLogEvent(String component, String message, Callback<Object> callback) {
        String syslogMessage = String.format(Locale.US, "<22>%s %s %s:%s", this.getSysLogFormattedDate(), this.utils.getApplicationName(this.context), component, message);
        this.sendDataOverUDP(syslogMessage, callback);
    }

    protected String getSysLogFormattedDate() {
        SimpleDateFormat df = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);
        Date now = new Date();
        return df.format(now);
    }

    protected void sendDataOverUDP(final String syslogMessage, final Callback<Object> deleteFileCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] message = syslogMessage.getBytes();
                    InetAddress address = InetAddress.getByName(UDPLoggingService.this.host);
                    DatagramPacket packet = new DatagramPacket(message, message.length, address, UDPLoggingService.this.port);
                    DatagramSocket datagramSocket = new DatagramSocket();
                    datagramSocket.send(packet);
                    datagramSocket.close();
                    if (deleteFileCallback != null) {
                        deleteFileCallback.success(null, null);
                    }
                }
                catch (Exception ex) {
                    UDPLoggingService.this.utils.logIssue("Error sending UDP log message", ex);
                }
            }
        }).start();
    }
}

