/*
 * Decompiled with CFR 0.152.
 */
package com.percolate.foam;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.SystemClock;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.Log;

class Utils {
    protected FoamLogger foamLogger = new FoamLogger();

    Utils() {
    }

    public boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNotBlank(CharSequence cs) {
        return !this.isBlank(cs);
    }

    public String trimToSize(String str, int maxStringLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxStringLength) {
            StringBuilder sb = new StringBuilder(str);
            sb.setLength(maxStringLength);
            str = sb.toString();
        }
        return str;
    }

    public void sleep(int ms) {
        SystemClock.sleep((long)ms);
    }

    public void logIssue(String message, Throwable ex) {
        this.foamLogger.w(message, ex);
    }

    public String getApplicationName(Context context) {
        int stringId = context.getApplicationInfo().labelRes;
        return context.getString(stringId);
    }

    public String getVersionName(Context context) {
        String versionName;
        try {
            versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionName = "";
        }
        return versionName;
    }

    public int getVersionCode(Context context) {
        int versionCode;
        try {
            versionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionCode = -1;
        }
        return versionCode;
    }

    public String getApplicationPackageName(Context context) {
        String packageName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            packageName = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException ex) {
            this.logIssue("Could not find package name.", ex);
        }
        return packageName;
    }

    @NonNull
    public String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (androidId == null) {
            return "";
        }
        return androidId;
    }

    public boolean isOnWifi(Context context) {
        try {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi.isConnected()) {
                return true;
            }
        }
        catch (Exception ex) {
            this.logIssue("Error checking wifi state", ex);
        }
        return false;
    }

    protected class FoamLogger {
        protected FoamLogger() {
        }

        protected void w(String message, Throwable ex) {
            if (ex != null) {
                Log.w((String)"Foam", (String)("Foam library: problem detected: " + message), (Throwable)ex);
            } else {
                Log.w((String)"Foam", (String)("Foam library: problem detected: " + message));
            }
        }
    }
}

