/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider;

import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Metadata {
    public static void main(String[] args) {
        try {
            Manifest manifest = Metadata.getManifest();
            Attributes attr = manifest.getMainAttributes();
            System.out.println(attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
            StringBuilder version = new StringBuilder(attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
            System.out.println(version);
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest() throws Exception {
        String className = Metadata.class.getSimpleName() + ".class";
        URL classURL = Metadata.class.getResource(className);
        if (classURL == null) {
            throw new Exception("Error retrieving class as resource: " + className);
        }
        String classPath = classURL.toString();
        if (!classPath.startsWith("jar")) {
            throw new Exception("Not running from jar file: " + classPath);
        }
        int separator = classPath.lastIndexOf(33);
        if (separator != -1 && separator + 1 >= classPath.length()) {
            throw new Exception("Invalid jar file class path: " + classPath);
        }
        String manifestPath = classPath.substring(0, separator + 1) + "/META-INF/MANIFEST.MF";
        InputStream inStream = null;
        try {
            inStream = new URL(manifestPath).openStream();
            Manifest manifest = new Manifest(inStream);
            return manifest;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

