/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.maven.scm.provider.p4;

import com.perforce.maven.scm.provider.p4.command.add.P4AddCommand;
import com.perforce.maven.scm.provider.p4.command.blame.P4BlameCommand;
import com.perforce.maven.scm.provider.p4.command.branch.P4BranchCommand;
import com.perforce.maven.scm.provider.p4.command.changelog.P4ChangeLogCommand;
import com.perforce.maven.scm.provider.p4.command.checkin.P4CheckInCommand;
import com.perforce.maven.scm.provider.p4.command.checkout.P4CheckOutCommand;
import com.perforce.maven.scm.provider.p4.command.diff.P4DiffCommand;
import com.perforce.maven.scm.provider.p4.command.edit.P4EditCommand;
import com.perforce.maven.scm.provider.p4.command.export.P4ExportCommand;
import com.perforce.maven.scm.provider.p4.command.info.P4InfoCommand;
import com.perforce.maven.scm.provider.p4.command.list.P4ListCommand;
import com.perforce.maven.scm.provider.p4.command.login.P4LoginCommand;
import com.perforce.maven.scm.provider.p4.command.remove.P4RemoveCommand;
import com.perforce.maven.scm.provider.p4.command.status.P4StatusCommand;
import com.perforce.maven.scm.provider.p4.command.tag.P4TagCommand;
import com.perforce.maven.scm.provider.p4.command.unedit.P4UnEditCommand;
import com.perforce.maven.scm.provider.p4.command.update.P4UpdateCommand;
import com.perforce.maven.scm.provider.p4.manager.P4ClientManager;
import com.perforce.maven.scm.provider.p4.repository.P4ScmProviderRepository;
import com.perforce.maven.scm.provider.p4.util.P4ScmUrl;
import com.perforce.maven.scm.provider.p4.util.P4Utils;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class P4ScmProvider
extends AbstractScmProvider {
    private P4ClientManager clientManager;

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        P4ScmUrl parser = null;
        try {
            parser = P4ScmUrl.parse("scm:p4:" + scmSpecificUrl);
        }
        catch (Exception e) {
            throw new ScmRepositoryException(e.getMessage());
        }
        return new P4ScmProviderRepository(parser.getProtocol(), parser.getHost(), parser.getPort(), parser.getPath(), parser.getUsername(), parser.getPassword());
    }

    public boolean requiresEditMode() {
        return true;
    }

    public String getScmType() {
        return "p4";
    }

    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4AddCommand command = new P4AddCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (AddScmResult)command.execute(repository, fileSet, params);
    }

    protected BlameScmResult blame(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4BlameCommand command = new P4BlameCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (BlameScmResult)command.execute(repository, fileSet, params);
    }

    protected BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4BranchCommand command = new P4BranchCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (BranchScmResult)command.execute(repository, fileSet, params);
    }

    protected CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4CheckInCommand command = new P4CheckInCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (CheckInScmResult)command.execute(repository, fileSet, params);
    }

    protected CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        ScmVersion scmVersion = params.getScmVersion(CommandParameter.SCM_VERSION, null);
        P4ScmProviderRepository p4Repo = (P4ScmProviderRepository)repository;
        if (scmVersion != null && !(scmVersion instanceof ScmTag) && scmVersion instanceof ScmBranch) {
            ScmBranch scmBranch = (ScmBranch)scmVersion;
            p4Repo.setPath(scmBranch.getName());
        }
        P4CheckOutCommand command = new P4CheckOutCommand();
        command.setLogger(this.getLogger());
        String clientName = this.clientManager.discoverClientName(p4Repo, fileSet.getBasedir());
        if (null == clientName) {
            clientName = P4Utils.getSettings().getClientName();
        }
        command.setClient(this.clientManager.getClient(p4Repo, fileSet.getBasedir(), clientName));
        return (CheckOutScmResult)command.execute(repository, fileSet, params);
    }

    protected ExportScmResult export(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4ExportCommand command = new P4ExportCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (ExportScmResult)command.execute(repository, fileSet, params);
    }

    protected ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        P4ChangeLogCommand command = new P4ChangeLogCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (ChangeLogScmResult)command.execute(repository, fileSet, parameters);
    }

    protected DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4DiffCommand command = new P4DiffCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (DiffScmResult)command.execute(repository, fileSet, params);
    }

    protected EditScmResult edit(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4EditCommand command = new P4EditCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (EditScmResult)command.execute(repository, fileSet, params);
    }

    public ListScmResult list(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4ListCommand command = new P4ListCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (ListScmResult)command.execute(repository, fileSet, params);
    }

    protected LoginScmResult login(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4LoginCommand command = new P4LoginCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (LoginScmResult)command.execute(repository, fileSet, params);
    }

    protected RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4RemoveCommand command = new P4RemoveCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (RemoveScmResult)command.execute(repository, fileSet, params);
    }

    protected StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4StatusCommand command = new P4StatusCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (StatusScmResult)command.execute(repository, fileSet, params);
    }

    protected TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4TagCommand command = new P4TagCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (TagScmResult)command.execute(repository, fileSet, params);
    }

    protected UnEditScmResult unedit(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4UnEditCommand command = new P4UnEditCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (UnEditScmResult)command.execute(repository, fileSet, params);
    }

    protected UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4UpdateCommand command = new P4UpdateCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (UpdateScmResult)command.execute(repository, fileSet, params);
    }

    public InfoScmResult info(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters params) throws ScmException {
        P4InfoCommand command = new P4InfoCommand();
        command.setLogger(this.getLogger());
        command.setClient(this.clientManager.getClient((P4ScmProviderRepository)repository, fileSet.getBasedir()));
        return (InfoScmResult)command.execute(repository, fileSet, params);
    }
}

